<?php


/**
* VGS Visual Pipeline Module
 *
 *
 * @package        VGSVisualPipeline Module
 * @author         Curto Francisco - www.vgsglobal.com
 * @license        vTiger Public License.
 * @version        Release: 1.0
 */

include_once 'modules/Vtiger/CRMEntity.php';
include_once 'include/utils/utils.php';

class VGSVisualPipeline extends Vtiger_CRMEntity
{
    
    public function __construct()
    {
    }
    
    
    /**
    * Invoked when special actions are performed on the module.
         * @param String Module name
         * @param String Event Type
         */
    function vtlib_handler($moduleName, $eventType)
    {
        $adb = PearDatabase::getInstance();
        if ($eventType == 'module.postinstall') {
            $this->addSettingsEntry();
            $this->addLinks();
            $this->checktables();

        } elseif ($eventType == 'module.disabled') {
            //  Remove all links
            $Tabid = getTabId("VGSVisualPipeline");
            Vtiger_Link::deleteLink($Tabid, 'HEADERSCRIPT', 'VGSVisualPipeline');
            
            // Hide Settings
            
            $adb = PearDatabase::getInstance();
            $adb->pquery("UPDATE vtiger_settings_field SET active=1 WHERE name=?", array('VGS Visual Pipeline'));
        
            //@TODO: Hide the links in the modules

        } elseif ($eventType == 'module.enabled') {
            $Tabid = getTabId("VGSVisualPipeline");
            Vtiger_Link::addLink($Tabid, 'HEADERSCRIPT', 'VGSVisualPipeline', 'layouts/vlayout/modules/VGSVisualPipeline/resources/VGSVisualPipeline.js', '', 0, '');
            
            $this->checkAndEnabledWS();
            $this->addSettingsEntry();
            
            $adb = PearDatabase::getInstance();
            $adb->pquery("UPDATE vtiger_settings_field SET active=0 WHERE name=?", array('VGS Visual Pipeline'));

            //@TODO: Show the links in the modules
        
        } elseif ($eventType == 'module.preuninstall') {
            // remove all link
            $Tabid = getTabId("VGSVisualPipeline");
            Vtiger_Link::deleteLink($Tabid, 'HEADERSCRIPT', 'VGSVisualPipeline');

            $db = PearDatabase::getInstance();
            $db->pquery("DELETE FROM vtiger_settings_field WHERE name=?", array('VGS Visual Pipeline'));
            $db->pquery("DELETE FROM vtiger_links WHERE linklabel=?", array('Kanban View'));
        
        } elseif ($eventType == 'module.preupdate') {
        } elseif ($eventType == 'module.postupdate') {
            $this->checkAndEnabledWS();
            $this->addSettingsEntry();
            $this->addLinks();
            $this->checktables();
        }
    }
    
    function checkAndEnabledWS()
    {
        $db = PearDatabase::getInstance();
        $result = $db->pquery("SELECT * FROM vtiger_ws_entity WHERE name=?", array('VGSVisualPipeline'));
        
        if ($result && $db->num_rows($result) == 0) {
            include_once 'vtlib/Vtiger/Module.php';
            $VPLInstance = Vtiger_Module::getInstance('VGSVisualPipeline');
            $VPLInstance->initWebservice();
        }
    }
    
    
    function addLinks()
    {
        require_once('vtlib/Vtiger/Link.php');
        
        include('vtigerversion.php');
        $version = explode('.', $vtiger_current_version)[0];
        
        if ($version > 6) {
            $Tabid = getTabId("VGSVisualPipeline");
            Vtiger_Link::addLink($Tabid, 'HEADERSCRIPT', 'VGSVisualPipeline', 'layouts/v7/modules/VGSVisualPipeline/resources/VGSVisualPipeline.js', '', 0, '');
        } else {
            $Tabid = getTabId("VGSVisualPipeline");
            Vtiger_Link::addLink($Tabid, 'HEADERSCRIPT', 'VGSVisualPipeline', 'layouts/vlayout/modules/VGSVisualPipeline/resources/VGSVisualPipeline.js', '', 0, '');
        }
    }
    
    function addSettingsEntry()
    {
        $adb = PearDatabase::getInstance();
        $otherSettingsBlock = $adb->pquery('SELECT * FROM vtiger_settings_blocks WHERE label=?', array('LBL_OTHER_SETTINGS'));
        $otherSettingsBlockCount = $adb->num_rows($otherSettingsBlock);
        
        if ($otherSettingsBlockCount > 0) {
            $blockid = $adb->query_result($otherSettingsBlock, 0, 'blockid');
            $sequenceResult = $adb->pquery("SELECT max(sequence) as sequence FROM vtiger_settings_blocks WHERE blockid=?", array($blockid));
            if ($adb->num_rows($sequenceResult)) {
                $sequence = $adb->query_result($sequenceResult, 0, 'sequence');
            }
        }
        
        $result = $adb->pquery('SELECT * FROM vtiger_settings_field WHERE name=?', array('VGS Visual Pipeline'));
        
        if ($result && $adb->num_rows($result) == 0) {
            $fieldid = $adb->getUniqueID('vtiger_settings_field');
            $adb->pquery("INSERT INTO vtiger_settings_field(fieldid, blockid, name, iconpath, description, linkto, sequence, active) 
                        VALUES(?,?,?,?,?,?,?,?)", array($fieldid, $blockid, 'VGS Visual Pipeline', '', 'VGS Visual Pipeline', 'index.php?module=VGSVisualPipeline&view=VGSIndexSettings&parent=Settings', $sequence++, 0));
        }
    }

    function checktables(){
        $db = pearDatabase::getInstance();
        //Make sure all the tables are in place
        if(!Vtiger_Utils::CheckTable('vtiger_vgsvisualpipeline')){
            $db->pquery('CREATE TABLE `vtiger_vgsvisualpipeline` (
                        `vgsvisualpipelineid` int(11) unsigned NOT NULL AUTO_INCREMENT,
                        `sourcefieldname` varchar(50) DEFAULT NULL,
                        `sourcemodule` varchar(50) DEFAULT NULL,
                        `selected_fields` text,
                        `ignoredvalues` text,
                        PRIMARY KEY (`vgsvisualpipelineid`)
                        ) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;');
        }

        if(!Vtiger_Utils::CheckTable('vtiger_vgsvisualsorting')){
            $db->pqquery('CREATE TABLE `vtiger_vgsvisualsorting` (
                        `module` varchar(50) DEFAULT NULL,
                        `sorting` text
                        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;');
        }

        //Add the columns for the lastest version fo the module (when updating)

        Vtiger_Utils::AddColumn('vtiger_vgsvisualpipeline','selected_fields', 'TEXT  NULL  AFTER `sourcemodule`');
        Vtiger_Utils::AddColumn('vtiger_vgsvisualpipeline','ignoredvalues', 'TEXT  NULL  AFTER `selected_fields`');
        
    }
}
