<?php

class VGSSummaryWidgets_reloadWidgets_View extends Vtiger_RelatedList_View {
    function process(Vtiger_Request $request) {
		$moduleName = $request->getModule();
		$relatedModuleName = $request->get('selected_module');
        $parentId = $request->get('record');
        
		$widgetModel = VGSSummaryWidgets_SummaryWidgets_Model::getInstanceById($request->get('widget_id'));

        if($widgetModel){
				$relatedRecordList = [];
				$label = $widgetModel->get('label');
				$relatedModuleName = $widgetModel->get('related_module');
				$parentModuleName = $widgetModel->get('primary_module');				
				$parentRecordModel =  Vtiger_Module_Model::getInstance($parentModuleName);
				$relatedModuleModel = Vtiger_Module_Model::getInstance($relatedModuleName);
				$moduleFields = $relatedModuleModel->getFields();

				
		
				$searchParams = $request->get('search_params');
				
				if(empty($searchParams)) {
					$searchParams = array();
				}
				
				

				$whereCondition = array();
				
				if($request->get('filter_value') != 'all'){
					$fieldSearchInfo = [];
					$fieldSearchInfo[] = $widgetModel->get('filter_by');
					$fieldSearchInfo[] = 'e';
					$fieldSearchInfo[] = $request->get('filter_value');
					$fieldSearchInfo[] = 'AND';

					$fieldModel = $moduleFields[$fieldSearchInfo[0]];
					$tableName = $fieldModel->get('table');
					$column = $fieldModel->get('column');
					$whereCondition[$fieldSearchInfo[0]] = array($tableName.'.'.$column, $fieldSearchInfo[1],  $fieldSearchInfo[2], $fieldSearchInfo[3]);
					
					$fieldSearchInfoTemp= array();
					$fieldSearchInfoTemp['searchValue'] = $fieldSearchInfo[2];
					$fieldSearchInfoTemp['fieldName'] = $fieldName = $fieldSearchInfo[0];
					$fieldSearchInfoTemp['comparator'] = $fieldSearchInfo[1];
					$searchParams[$fieldName] = $fieldSearchInfoTemp;
				}

				

			   
				$requestedPage = $request->get('page');
				if(empty($requestedPage)) {
					$requestedPage = 1;
				}
		
				$pagingModel = new Vtiger_Paging_Model();
				$pagingModel->set('page',$requestedPage);
		
				$parentRecordModel = Vtiger_Record_Model::getInstanceById($parentId, $widgetModel->get('primary_module'));
				$relationListView = Vtiger_RelationListView_Model::getInstance($parentRecordModel, $relatedModuleName);
				
				if(!empty($whereCondition))
					$relationListView->set('whereCondition', $whereCondition);

				if(!empty($orderBy)) {
					$relationListView->set('orderby', $orderBy);
					$relationListView->set('sortorder',$sortOrder);
				}
				$relationListView->tab_label = $label;
				$models = $relationListView->getEntries($pagingModel);
				foreach ($models as $recordId => $recordModel) {
					$relatedRecordList[$recordId] = Vtiger_Record_Model::getInstanceById($recordId, $relatedModuleName);
				}

				if(count($relatedRecordList) > 0) {
					
					
					$header=array();
					$fieldList=explode('::', $widgetModel->get('columns'));
					if( $fieldList)
					{
						foreach ($fieldList as $fieldname) {
							$moduleModel = Vtiger_Module_Model::getInstance($relatedModuleName);
								$fieldModel = Vtiger_Field_Model::getInstance($fieldname, $moduleModel);
								if ($fieldModel->isViewable()) {
									$header[$fieldname]=$fieldModel;
								}
						}
					}else{
						$header = $relationListView->getHeaders();
						
					}
	
					
				}

				
				$viewer = $this->getViewer($request);
				
				$viewer->assign('MODULE' , $moduleName);
				$viewer->assign('WIDGET_LABEL' , $label);
				$viewer->assign('RELATED_RECORDS' , $relatedRecordList);
				$viewer->assign('RELATED_HEADERS', $header);
				$viewer->assign('WIDGET_ID', $widgetModel->get('vgswidgetsid'));
				$viewer->assign('SHOW_ADD', $widgetModel->get('show_add'));
				$viewer->assign('FILTER_FIELD', $widgetModel->get('filter_by'));
				$filterFieldModel = Vtiger_Field_Model::getInstance($widgetModel->get('filter_by'),$relatedModuleModel);
				$viewer->assign('FILTER_OPTIONS', $filterFieldModel->getPicklistValues());
				$viewer->assign('FILTER_OPTIONS_SELECTED', $request->get('filter_value'));
				$relationModel = $relationListView->getRelationModel();
				
				if($relationModel->getRelationField()){
					$relatedField = $relationModel->getRelationField()->getName();
				}

				$viewer->assign('RELATED_FIELD_NAME', $relatedField);
				$viewer->assign('RELATED_LINK_URL', $relationListView->getCreateViewUrl());

				$relatedModuleModel = Vtiger_Module_Model::getInstance($relatedModuleName);
				$viewer->assign('RELATED_MODULE_MODEL', $relatedModuleModel);
				$viewer->assign('RELATED_MODULE_NAME', $relatedModuleName);
				$widgetsResponse = $viewer->view('RelatedWidgetsContent.tpl', $moduleName,true);

				
			
					
		}
		
		$response = new Vtiger_Response();
		$response->setResult($widgetsResponse);
		$response->emit();

	}
}
