<?php

class VGSSummaryWidgets_loadWidgets_View extends Vtiger_RelatedList_View {
    function process(Vtiger_Request $request) {
		$moduleName = $request->getModule();
		$relatedModuleName = $request->get('selected_module');
        $parentId = $request->get('record');
        
        $availableWidgets = VGSSummaryWidgets_SummaryWidgets_Model::getWidgetsForModule($relatedModuleName);

        if(is_array($availableWidgets) && count($availableWidgets) == 0){
            $response = new Vtiger_Response();
            $response->setError('200', 'No widgets available');
            $response->emit();
            return false;
        }

        foreach ($availableWidgets as $widgetPlacement => $widgetModelArray) {
			foreach ($widgetModelArray as $widgetModel) {
				$relatedRecordList = [];
				$label = $widgetModel->get('label');
				$relatedModuleName = $widgetModel->get('related_module');
				$parentModuleName = $widgetModel->get('primary_module');				
				$parentRecordModel =  Vtiger_Module_Model::getInstance($parentModuleName);
				$relatedModuleModel = Vtiger_Module_Model::getInstance($relatedModuleName);
				$moduleFields = $relatedModuleModel->getFields();
			   
				$requestedPage = $request->get('page');
				if(empty($requestedPage)) {
					$requestedPage = 1;
				}
		
				$pagingModel = new Vtiger_Paging_Model();
				$pagingModel->set('page',$requestedPage);
		
				$parentRecordModel = Vtiger_Record_Model::getInstanceById($parentId, $widgetModel->get('primary_module'));
				$relationListView = Vtiger_RelationListView_Model::getInstance($parentRecordModel, $relatedModuleName);
				$links = $relationListView->getLinks();
				
				if(!empty($orderBy)) {
					$relationListView->set('orderby', $orderBy);
					$relationListView->set('sortorder',$sortOrder);
				}
				$relationListView->tab_label = $label;
				$models = $relationListView->getEntries($pagingModel);
				foreach ($models as $recordId => $recordModel) {
					$relatedRecordList[$recordId] = Vtiger_Record_Model::getInstanceById($recordId, $relatedModuleName);
				}

				$header=array();
				$fieldList=explode('::', $widgetModel->get('columns'));
				if( $fieldList)
				{
					foreach ($fieldList as $fieldname) {
						$moduleModel = Vtiger_Module_Model::getInstance($relatedModuleName);
							$fieldModel = Vtiger_Field_Model::getInstance($fieldname, $moduleModel);

							// @change t45306
							// if ($fieldModel->isViewable()) {
							if (!is_bool($fieldModel) && $fieldModel->isViewable()) {
							//

								$header[$fieldname]=$fieldModel;
							}
					}
				}else{
					$header = $relationListView->getHeaders();
					
				}

				$viewer = $this->getViewer($request);
	   
				$viewer->assign('MODULE' , $moduleName);
				$viewer->assign('WIDGET_LABEL' , $label);
				$viewer->assign('RELATED_RECORDS' , $relatedRecordList);
				$viewer->assign('RELATED_HEADERS', $header);
				$viewer->assign('SHOW_ADD', $widgetModel->get('show_add'));
				$viewer->assign('WIDGET_ID', $widgetModel->get('vgswidgetsid'));
                $viewer->assign('FILTER_FIELD', $widgetModel->get('filter_by'));
                $viewer->assign('SHOW_ADD', $widgetModel->get('show_add'));
				$filterFieldModel = Vtiger_Field_Model::getInstance($widgetModel->get('filter_by'),$relatedModuleModel);
				$viewer->assign('FILTER_OPTIONS', $filterFieldModel->getPicklistValues());
				$relationModel = $relationListView->getRelationModel();

				if($relationModel->getRelationField()){
					$relatedField = $relationModel->getRelationField()->getName();
				}

				$viewer->assign('RELATED_FIELD_NAME', $relatedField);
				$viewer->assign('RELATED_LINK_URL', $relationListView->getCreateViewUrl());

				$relatedModuleModel = Vtiger_Module_Model::getInstance($relatedModuleName);
				$viewer->assign('RELATED_MODULE_MODEL', $relatedModuleModel);
				$viewer->assign('RELATED_MODULE_NAME', $relatedModuleName);
				$widgetsResponse[$widgetPlacement][] = $viewer->view('RelatedWidgetsContent.tpl', $moduleName,true);
			}
					
		}
		
		$response = new Vtiger_Response();
		$response->setResult($widgetsResponse);
		$response->emit();

	}
}
