<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

class VGSSummaryWidgets_VGSWidgetsModal_View extends Vtiger_IndexAjax_View {

	public function checkPermission(Vtiger_Request $request) {
		$moduleName = $request->getModule();
		$currentUserModel = Users_Record_Model::getCurrentUserModel();

		if(!$currentUserModel->isAdminUser()) {
			throw new AppException(vtranslate('LBL_PERMISSION_DENIED', $moduleName));
		}
	}

	public function process (Vtiger_Request $request) {
		$viewer = $this->getViewer($request);
		$moduleName = $request->getModule();
		$selectedModule = $request->get('selected_module');

		if ($request->has('widget_id') && $request->get('widget_id') !== '') {

			$summaryWidgetModel = VGSSummaryWidgets_SummaryWidgets_Model::getInstanceById($request->get('widget_id'));

			$viewer->assign('WIDGET_ID', $summaryWidgetModel->getId());
			$viewer->assign('LABEL', $summaryWidgetModel->get('label'));
			$viewer->assign('ENTRY_QTY', $summaryWidgetModel->get('entries_qty'));
			$viewer->assign('RELATED_MOD', $summaryWidgetModel->get('related_module'));
			$viewer->assign('SELECTED_COLUMNS', explode('::',$summaryWidgetModel->get('columns')));

			$relModuleModel = Vtiger_Module_Model::getInstance($summaryWidgetModel->get('related_module'));
			$moduleFields = $relModuleModel->getFields();
			$columns = [];
			foreach ($moduleFields as $fieldName => $fieldInstance) {
				$columns[$fieldName] = vtranslate($fieldInstance->get('label'), $summaryWidgetModel->get('related_module'));
			}

			$viewer->assign('COLUMNS', $columns);

			$modulePicklistFields = $relModuleModel->getFieldsByType('picklist');			
			$picklistFields = [];
			foreach ($modulePicklistFields as $fieldName => $fieldInstance) {
				$picklistFields[$fieldName] = vtranslate($fieldInstance->get('label'), $summaryWidgetModel->get('related_module'));
			}

			$viewer->assign('PICKLIST_FIELDS', $picklistFields);
			$viewer->assign('FILTER_BY', $summaryWidgetModel->get('filter_by'));			
			$viewer->assign('SHOW_ADD', $summaryWidgetModel->get('show_add'));
			$viewer->assign('WIDGET_PLACEMENT', $summaryWidgetModel->get('widgetplacement'));
		}

		$viewer->assign('SELECTED_MOD', $selectedModule);
		$viewer->assign('RELATED_MOD_ARRAY', $this->getRelatedModules($selectedModule));
		
		$viewer->assign('MODULE',$moduleName);
		$viewer->view('EditModal.tpl', $moduleName);
	}

	function getRelatedModules($selectedModule){

		$relModulesArray = Vtiger_Relation_Model::getAllRelations(Vtiger_Module_Model::getInstance($selectedModule));
		$relModArray = [];
		$restrictedModules = ['Emails', 'ModComments', 'PBXManager', 'Documents'];
		foreach ($relModulesArray as $relationModel) {
			if(!in_array($relationModel->get('relatedModuleName'), $restrictedModules)){
				$relModArray[$relationModel->get('relatedModuleName')]= vtranslate($relationModel->get('relatedModuleName'), $relationModel->get('relatedModuleName'));
			}
		}

		//Search for Uitype 10 fields

		$db = PearDatabase::getInstance();
		$result = $db->pquery('SELECT vtiger_fieldmodulerel.module 
									FROM vtiger_field INNER JOIN vtiger_fieldmodulerel ON vtiger_field.fieldid = vtiger_fieldmodulerel.fieldid
									WHERE relmodule=? AND presence IN (0,2)', [$selectedModule]);
		if($result && $db->num_rows($result) > 0){
			while ($row = $db->fetch_row($result)) {
				if(!in_array($row['module'], $restrictedModules)){
					$relModArray[$row['module']] = vtranslate($row['module'], $row['module']);
				}
			}
		}							

		return $relModArray;
	}

	function getCustomUIs($sourceModule){
        $customsUIs = $this->getCustomUITypes();
        
        if($sourceModule == 'Accounts'){
            return 'uitype IN (73,51)';
        }elseif(array_key_exists($sourceModule,$customsUIs)){
            return 'uitype IN (' . $customsUIs[$sourceModule] . ')';
        }
        
        return '';   
	}
	
	public static function getCustomUITypes() {
        $customUI = array(
            'Accounts' => '51',
            'Contacts' => '57',
            'Potentials' => '76',
            'Products' => '59',
            'Quotes' => '78',
            'SalesOrder' => '80',
            'Vendors' => '81',
        );

        return $customUI;
    }
}
