<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

class VGSSummaryWidgets_VGSWidgetList_View extends Vtiger_IndexAjax_View {

	public function checkPermission(Vtiger_Request $request) {
		$moduleName = $request->getModule();
		$currentUserModel = Users_Record_Model::getCurrentUserModel();

		if(!$currentUserModel->isAdminUser()) {
			throw new AppException(vtranslate('LBL_PERMISSION_DENIED', $moduleName));
		}
	}

	public function process (Vtiger_Request $request) {
		$viewer = $this->getViewer($request);
		$moduleName = $request->getModule();
		$selectedModule = $request->get('selected_module');

		//@TODO: Get all the widgets available for the module
		$widgetArray = [];
		$db = PearDatabase::getInstance();
		$result = $db->pquery('SELECT * FROM vtiger_vgswidgets WHERE primary_module=? order by sequence',[$selectedModule]);

		if($result && $db->num_rows($result)){
			while ($row = $db->fetch_row($result)) {
				$widgetArray[$row['widgetplacement']][] = VGSSummaryWidgets_SummaryWidgets_Model::getInstanceById($row['vgswidgetsid']);
			}
		}

		if(is_array($widgetArray) && count($widgetArray) == 0){
			$viewer->assign('NO_WIDGETS', vtranslate('No Widgets for selected module.',$moduleName));
		}else{
			$viewer->assign('NO_WIDGETS', '');
		}
		
        

		$viewer->assign('RIGHT_WIDGETS', $widgetArray['rightwidgets']);
		$viewer->assign('LEFT_WIDGETS',$widgetArray['leftwidgets']);
		$viewer->view('VGSWidgetList.tpl', $moduleName);
	}

	
}
