<?php

/**
 * VGS Visual Pipeline Module
 *
 *
 * @package        VGSVisualPipeline Module
 * @author         VGS Global - www.vgsglobal.com
 * @license        vTiger Public License.
 * @version        Release: 1.0
 */

include_once 'modules/VGSSummaryWidgets/models/VGSLicenseManager.php';


class VGSSummaryWidgets_VGSIndexSettings_View extends Settings_Vtiger_Index_View {

    public function process(Vtiger_Request $request) {

            $entityModules = Vtiger_Module_Model::getEntityModules();
            $restrictedModules = array('Emails','Documents','Campaigns', 'Calendar','Faq','Webmails','ModComments', 'SMSNotifier', 'PBXManager'); //Modules where related fields do not work as expected
    
            $modules = array();
            foreach ($entityModules as $entityModule) {
                if(!in_array($entityModule->name, $restrictedModules)){
                    array_push($modules, $entityModule->name);
                }
            }

            $viewer = $this->getViewer($request);
            $viewer->assign('ENTITY_MODULES', $modules);
    
            $viewer->view('VGSSummaryWidgets.tpl', $request->getModule());

        

    }

    function getPageTitle(Vtiger_Request $request) {
        return vtranslate('VGS Summary Widgets', $request->getModule());
    }


    /**
     * Function to get the list of Script models to be included
     * @param Vtiger_Request $request
     * @return <Array> - List of Vtiger_JsScript_Model instances
     */
    function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        require_once('vtlib/Vtiger/Link.php');
       
        $jsFileNames = array(
            "layouts.v7.modules.VGSSummaryWidgets.resources.VGSWidgetsSettings",
        );
       
        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }
}
