<?php


class VGSSummaryWidgets_SummaryWidgets_Model extends Vtiger_Base_Model {

	public function save() {
		$db = PearDatabase::getInstance();

		$currentUserModel = Users_Record_Model::getCurrentUserModel();
		$currentUserId = $currentUserModel->getId();

		$params = array(
			$this->get('primary_module'),
			$this->get('related_module'), 
			$this->get('label'), 
			$this->get('entries_qty'), 
			$this->get('filter_by'),
			$this->get('columns'),
			$this->get('show_add'),
			$this->get('widgetplacement')
		);

		if($this->get('mode') != 'edit') {


			$sort = $this->getWidgetSort($this->get('primary_module'), $this->get('widgetplacement'));
			$params[] = $sort;
			$result = $db->pquery("INSERT INTO vtiger_vgswidgets(primary_module, related_module, label, entries_qty, filter_by, columns, show_add, widgetplacement, sequence) VALUES(?, ?, ?, ?, ?, ?, ?, ?,?)", $params);
			if(!$result){
				return false;
			}


		} else {
			$params[] = $this->get('vgswidgetsid');
			$db->pquery('UPDATE vtiger_vgswidgets SET primary_module=?, related_module=?, label=?, entries_qty=?, filter_by=?, columns=?, show_add=?, widgetplacement=? WHERE vgswidgetsid=?', $params);
		}

		return $this;
	}

	public function delete() {
		$db = PearDatabase::getInstance();
		$folderId = $this->getId();
		$result = $db->pquery("DELETE FROM vtiger_attachmentsfolder WHERE folderid = ? AND foldername != 'Default'", array($folderId));
		return $this;
	}

	public static function getInstance() {
		return new self();
	}

	public static function getInstanceById($widgetId) {
		$db = PearDatabase::getInstance();
		$widgetModel = VGSSummaryWidgets_SummaryWidgets_Model::getInstance();

		$result = $db->pquery("SELECT * FROM vtiger_vgswidgets WHERE vgswidgetsid = ?", array($widgetId));
		$num_rows = $db->num_rows($result);
		if ($num_rows > 0) {
			$values = $db->query_result_rowdata($result, 0);
			$widgetModel->setData($values);
		}
		return $widgetModel;
	}


	public function getId() {
		return $this->get('vgswidgetsid');
	}

	
	public function getLabel() {
		return $this->get('label');
	}

	function getRelModule() {
		return vtranslate($this->get('related_module'), $this->get('related_module'));
	}


	function getColumns() {

		$fields = $this->getFieldsForModule($this->get('related_module')); 
		$columnsArray = explode('::', $this->get('columns'));
		
		foreach ($columnsArray as $key => $value) {
			$columnsArray[$key] = vtranslate($fields[$value],$this->get('related_module'));
		}

		return $columnsArray;
	}

	function getColumnList(){
		return implode(' | ', $this->getColumns());
	}

	public static function getFieldsForModule($moduleName) {
        $db = PearDatabase::getInstance();
        $picklistFields = Array();
        $sql = "SELECT fieldname, fieldlabel FROM vtiger_field WHERE presence IN (0,2) AND tabid=?";
        $res = $db->pquery($sql, array(getTabId($moduleName)));
        while ($row = $db->fetchByAssoc($res)) {
            $picklistFields[$row['fieldname']] = vtranslate($row['fieldlabel'], $moduleName);
        }

        return $picklistFields;
	}
	
	public static function getWidgetsForModule($moduleName){
		//@TODO: Get all the widgets available for the module
		$widgetArray = [];
		$db = PearDatabase::getInstance();
		$result = $db->pquery('SELECT * FROM vtiger_vgswidgets WHERE primary_module=? order by sequence',[$moduleName]);

		if($result && $db->num_rows($result)){
			while ($row = $db->fetch_row($result)) {
				$widgetArray[$row['widgetplacement']][] = VGSSummaryWidgets_SummaryWidgets_Model::getInstanceById($row['vgswidgetsid']);
			}
		}

		return $widgetArray;
	}

	function getWidgetSort($primaryModule, $widgetPlacement){
		$db = PearDatabase::getInstance();
		$result = $db->pquery('SELECT max(sequence) as sequence_w FROM vtiger_vgswidgets WHERE primary_module = ? AND widgetplacement=?', [$primaryModule, $widgetPlacement]);

		if($result && $db->num_rows($result)>0){
			$sortNumber = $db->query_result($result,0,'sequence_w');
			if(is_null($sortNumber) || $sortNumber == ''){
				return 1;
			} else {
				return $sortNumber+1;
			}
		}else{
			return 1;
		}

	}

}
?>
