<?php

/**
 * VGS Summary Widgets Module
 *
 *
 * @package        VGSSummaryWidgets Module
 * @author         VGS Global, Maggi Conrado - www.vgsglobal.com
 * @license        vTiger Public License.
 * @version        Release: 1.0
 */

class VGSSummaryWidgets_WidgetActions_Action extends Vtiger_Action_Controller {

    public function checkPermission(Vtiger_Request $request) {
        global $current_user;

        if (!is_admin($current_user)) {
            throw new AppException('LBL_PERMISSION_DENIED');
        }
    }

    public function process(Vtiger_Request $request) {
        $db = PearDatabase::getInstance();

        switch ($request->get('mode')) {
            case 'loadModulesColumns':
                $selectedModule = $request->get('for_module');
                $relModuleModel = Vtiger_Module_Model::getInstance($selectedModule);
                $moduleFields = $relModuleModel->getFields();

                $options = '';
                foreach ($moduleFields as $fieldName => $fieldInstance) {
                        $options .= '<option value="' . $fieldName. '">' . vtranslate($fieldInstance->get('label'), $selectedModule) . '</option>';
                }

                $result['columns'] = $options;

                $modulePicklistFields = $relModuleModel->getFieldsByType('picklist');
                
                $options = '';
                foreach ($modulePicklistFields as $fieldName => $fieldInstance) {
                        $options .= '<option value="' . $fieldName. '">' . vtranslate($fieldInstance->get('label'), $selectedModule) . '</option>';
                }

                $result['picklists'] = $options;

                $response = new Vtiger_Response();
                $response->setResult($result);
                $response->emit();
                break;

            case 'saveWidget':

                $moduleName = $request->getModule();
                $primaryModule = $request->get('primary_module');
                $relatedModule = $request->get('related_module');
                $label = $request->get('label');
                $entriesQty = $request->get('entries_qty');
                $filterdBy = $request->get('picklistfields');
                $cvColumns = $request->get('columns');
                $showQc = 0;
                if($request->get('show_add') == 'on'){
                    $showQc = 1;
                }
                $placement = $request->get('widgetplacement');

                if($relatedModule == '' || $label == '' || $entriesQty == '' || $cvColumns == ''){
                    $response = new Vtiger_Response();
                    $response->setError('1000', vtranslate('Mandatory Fields Missing', $moduleName));
                    $response->emit();
                }else{

                    $saveMode = $request->get('savemode');
                    $vgsWidgetModel = VGSSummaryWidgets_SummaryWidgets_Model::getInstance();
                    if($saveMode == 'edit') {
                        $widgetId = $request->get('vgswidget_id');
                        $vgsWidgetModel = VGSSummaryWidgets_SummaryWidgets_Model::getInstanceById($widgetId);
                        $vgsWidgetModel->set('mode','edit');                
                    }
                    
                    if($showQc == 'on'){
                        $showQc = 1;
                    }else{
                        $showQc = 0;
                    }


                    $vgsWidgetModel->set('label', $label);
                    $vgsWidgetModel->set('entries_qty', $entriesQty);
                    $vgsWidgetModel->set('primary_module', $primaryModule);                
                    $vgsWidgetModel->set('related_module', $relatedModule);
                    $vgsWidgetModel->set('related_field', $folderDesc);
                    $vgsWidgetModel->set('filter_by', $filterdBy);
                    $vgsWidgetModel->set('columns', implode('::',$cvColumns));
                    $vgsWidgetModel->set('show_add', $showQc);
                    $vgsWidgetModel->set('widgetplacement', $placement);

              
                    $widget = $vgsWidgetModel->save();
                    if($widget){
                        $result = array('success'=>true, 'message'=>vtranslate('Widget Successfully Saved', $moduleName), 'info'=>$vgsWidgetModel->getInfoArray());
                    }else{
                        $result = array('success'=>false, 'message'=>vtranslate('Error Adding the Widget', $moduleName), 'info'=>$vgsWidgetModel->getInfoArray());
                    }
                    
                    $response = new Vtiger_Response();
                    $response->setResult($result);
                    $response->emit();
                    
                }

                break;
            case 'deleteWidget':
                $db->pquery("DELETE FROM vtiger_vgswidgets WHERE vgswidgetsid=?", array($request->get('widget_id')));
                $fieldsResponse['result'] = 'ok';
                $response = new Vtiger_Response();
                $response->setResult($fieldsResponse);
                $response->emit();
                break;
            case 'updateWidgetsSideAndOrder':
                $array = $request->get('array');
                foreach ($array as $side => $arr) {
                    $sql = "UPDATE vtiger_vgswidgets SET widgetplacement = '$side', sequence = case ";
                    foreach ($arr as $index => $widget_id) {
                        if(!$widget_id) continue;
                        $ids[] = $widget_id;
                        $sql .= "when vgswidgetsid = $widget_id then $index ";
                    }
                    $sql .= "end "
                            . "WHERE vgswidgetsid IN (". implode(',',$ids).")";
                    $result = $db->pquery($sql);
                    unset($ids);
                }
                $fieldsResponse['result'] = 'ok';
                $response = new Vtiger_Response();
                $response->setResult($fieldsResponse);
                $response->emit();
                break;
            
            default:

                $response = new Vtiger_Response();
                $response->setError('200', 'Sorry, Action not available');
                $response->emit();
                break;
        }
    }

}
