<?php


/**
* VGS Summary Widgets Module
 *
 *
 * @package        VGSSummaryWidgets Module
 * @author         VGS Global - www.vgsglobal.com
 * @license        vTiger Public License.
 * @version        Release: 1.0
 */

include_once 'modules/Vtiger/CRMEntity.php';
include_once 'include/utils/utils.php';

class VGSSummaryWidgets extends Vtiger_CRMEntity
{
    
    public function __construct()
    {
    }
    
    
    /**
    * Invoked when special actions are performed on the module.
         * @param String Module name
         * @param String Event Type
         */
    function vtlib_handler($moduleName, $eventType)
    {
        $adb = PearDatabase::getInstance();
        if ($eventType == 'module.postinstall') {
            $this->addSettingsEntry();
            $this->addLinks();

        } elseif ($eventType == 'module.disabled') {
            //  Remove all links
            $Tabid = getTabId("VGSSummaryWidgets");
            Vtiger_Link::deleteLink($Tabid, 'HEADERSCRIPT', 'VGSSummaryWidgets');
            
            // Hide Settings
            
            $adb = PearDatabase::getInstance();
            $adb->pquery("UPDATE vtiger_settings_field SET active=1 WHERE name=?", array('Summary Widgets'));
        
            //@TODO: Hide the links in the modules

        } elseif ($eventType == 'module.enabled') {
            
            $this->addLinks();
            $this->addSettingsEntry();
            
            $adb = PearDatabase::getInstance();
            $adb->pquery("UPDATE vtiger_settings_field SET active=0 WHERE name=?", array('Summary Widgets'));

        
        } elseif ($eventType == 'module.preuninstall') {
            // remove all link
            $Tabid = getTabId("VGSSummaryWidgets");
            Vtiger_Link::deleteLink($Tabid, 'HEADERSCRIPT', 'VGSSummaryWidgets');

            $db = PearDatabase::getInstance();
            $db->pquery("DELETE FROM vtiger_settings_field WHERE name=?", array('Summary Widgets'));
        
        } elseif ($eventType == 'module.preupdate') {
        } elseif ($eventType == 'module.postupdate') {
            $this->addSettingsEntry();
            $this->addLinks();
        }
    }
    
    function addLinks()
    {
        require_once('vtlib/Vtiger/Link.php');
        $Tabid = getTabId("VGSSummaryWidgets");
        Vtiger_Link::addLink($Tabid, 'HEADERSCRIPT', 'VGSSummaryWidgets', 'layouts/v7/modules/VGSSummaryWidgets/resources/VGSWidgets.js', '', 0, '');
        
    }
    
    function addSettingsEntry()
    {
        $adb = PearDatabase::getInstance();
        $otherSettingsBlock = $adb->pquery('SELECT * FROM vtiger_settings_blocks WHERE label=?', array('LBL_OTHER_SETTINGS'));
        $otherSettingsBlockCount = $adb->num_rows($otherSettingsBlock);
        
        if ($otherSettingsBlockCount > 0) {
            $blockid = $adb->query_result($otherSettingsBlock, 0, 'blockid');
            $sequenceResult = $adb->pquery("SELECT max(sequence) as sequence FROM vtiger_settings_blocks WHERE blockid=?", array($blockid));
            if ($adb->num_rows($sequenceResult)) {
                $sequence = $adb->query_result($sequenceResult, 0, 'sequence');
            }
        }
        
        $result = $adb->pquery('SELECT * FROM vtiger_settings_field WHERE name=?', array('Summary Widgets'));
        
        if ($result && $adb->num_rows($result) == 0) {
            $fieldid = $adb->getUniqueID('vtiger_settings_field');
            $adb->pquery("INSERT INTO vtiger_settings_field(fieldid, blockid, name, iconpath, description, linkto, sequence, active) 
                        VALUES(?,?,?,?,?,?,?,?)", array($fieldid, $blockid, 'Summary Widgets', '', 'VGS Summary Widgets', 'index.php?module=VGSSummaryWidgets&view=VGSIndexSettings&parent=Settings', $sequence++, 0));
        }
    }
}
