<?php

/**
* VGS Related Module Updates
 *
 *
 * @package        VGSRelModUpdates Module
 * @author         Conrado Maggi
 * @license        Comercial / VPL
 * @copyright      2014 VGS Global
 * @version        Release: 1.0
 */

class VGSEventsInvites extends VTEventHandler {
	
	function handleEvent($eventName, $entityData) {
		global $adb;
		if ($eventName == 'vtiger.entity.aftersave.final') {
			$moduleName = $entityData->getModuleName();
			
			if ($moduleName == 'Events') {
				
				$eventsinvites=str_replace(' ', '', $entityData->get("eventsinvites"));
				$eventsinvites=explode(",", $eventsinvites);
				
				$sql="SELECT * FROM vtiger_vgseventinvites WHERE eventid=".$entityData->getId();
				$res=$adb->pquery($sql);
				
				$enviados=array();
				while($row = $adb->fetch_array($res)){
					$enviados[$row["email"]]=$row["sequence"];
				}
				
                $entityDelta = new VTEntityDelta();
                $timeStartHasChanged = $entityDelta->hasChanged($entityData->getModuleName(), $entityData->getId(), 'time_start');
                $dateStartHasChanged = $entityDelta->hasChanged($entityData->getModuleName(), $entityData->getId(), 'date_start');
                $dueDateHasChanged = $entityDelta->hasChanged($entityData->getModuleName(), $entityData->getId(), 'due_date');
                $timeEndHasChanged = $entityDelta->hasChanged($entityData->getModuleName(), $entityData->getId(), 'time_end');

				
				for ($i=0;$i<count($eventsinvites);$i++){
					if($eventsinvites[$i]==""){
                        continue;
                    }elseif(!isset($enviados[$eventsinvites[$i]])){
                        $this->sendInvitation($eventsinvites[$i],"new",$entityData,1, $eventsinvites);
                        $eventUUID = md5('VGSEventsInvites'.$entityData->getId());
						$sql="INSERT INTO vtiger_vgseventinvites (eventid,sequence,event_uuid,email) VALUES (".$entityData->getId().",1,'". $eventUUID ."','".$eventsinvites[$i]."')";
						$res=$adb->pquery($sql);
					}else{
						if( $timeStartHasChanged || $dateStartHasChanged || $dueDateHasChanged || $timeEndHasChanged ){
							$this->sendInvitation($eventsinvites[$i],"edit",$entityData,$enviados[$eventsinvites[$i]]+1, $eventsinvites);
							$sql="UPDATE vtiger_vgseventinvites SET sequence=".(intval($enviados[$eventsinvites[$i]])+1).",event_uuid='" . $eventUUID . "' WHERE email LIKE '".str_replace(' ', '', $eventsinvites[$i])."' and eventid=".$entityData->getId();
							$res=$adb->pquery($sql);
							
						}
					}
					
				}
			}
		}
	}
	
	function sendInvitation($email,$mode,$entityData,$seq, $eventAttedants) {
		global $current_user,$mod_strings;
		require_once("vtlib/Vtiger/Mailer.php");
		$invitees_array = explode(';',$inviteesid);
		
		if($mode == 'edit') {
			$subject = vtranslate("LBL_UPDATED_INVITATION", "Calendar").' : ';
		}
		else {
			$subject = vtranslate("LBL_INVITATION", "Calendar").' : ';
		}
		
        $subject .= $entityData->get('subject');

        $eventTimeZone = str_replace(';TZID=','',$this->getTimeZone($entityData->get("events_timezone")));

        $startTime = DateTimeField::convertToUserTimeZone($entityData->get('time_start'))->format('H:i:s');
        $endTime = DateTimeField::convertToUserTimeZone($entityData->get('time_end'))->format('H:i:s');

		$date_start = date('D M d, Y H:i', strtotime($entityData->get('date_start') .' '. $startTime));
		$date_end = date('H:i', strtotime($entityData->get('due_date') .' '. $endTime));
		
		$currentUserModel = Users_Record_Model::getCurrentUserModel();
		$userName = $currentUserModel->getName();
		$fromEmail = Emails_Record_Model::getFromEmailAddress();
		
		$attachment = $this->generateIcsAttachment($seq,$entityData, $email, $eventAttedants);

		
		$description = $entityData->get('description');

		if($description == ''){
			$description = $subject;
		}
        
		$mail = new Vtiger_Mailer();
		$mail->IsHTML(true);
		$mail->ConfigSenderInfo($fromEmail,$userName);
		$mail->Subject = "$subject @ $date_start - $date_end $eventTimeZ ($userName)";
		$mail->Body = $description;
		$mail->Body = nl2br($description);
		$mail->AddAttachment($attachment, '', 'base64', 'text/calendar');
		$mail->SendTo($email,'',false,false,true);
		
		unlink($attachment);
		
	}
	
	function generateIcsAttachment($seq,$record, $inviteEmail, $eventAttedants) {
		$fileName = "invite";
		
		$assignedUserId = $record->get('assigned_user_id');
		$userModel = Users_Record_Model::getInstanceById($assignedUserId, 'Users');
		$firstName = $userModel->entity->column_fields['first_name'];
		$lastName = $userModel->entity->column_fields['last_name'];
		$email = $userModel->entity->column_fields['email1'];
		
		
		$eventTimeZone = $this->getTimeZone($record->get("events_timezone"));
		

        $startTime = DateTimeField::convertToUserTimeZone($record->get('time_start'))->format('H:i:s');
		$endTime = DateTimeField::convertToUserTimeZone($record->get('time_end'))->format('H:i:s');
		
		//Llevar a UTC Considerando el Timezone del evento

		$startTime = DateTimeField::convertTimeZone($startTime, $eventTimeZone, 'UTC')->format('H:i:s');
		$endTime = DateTimeField::convertTimeZone($endTime, $eventTimeZone, 'UTC')->format('H:i:s');

		$fp = fopen('test/upload/'.$fileName.'.ics', "w");
		fwrite($fp, "BEGIN:VCALENDAR\nPRODID:-//Google Inc//Google Calendar 70.9054//EN\nVERSION:2.0\nCALSCALE:GREGORIAN\nMETHOD:REQUEST\nBEGIN:VEVENT\n");
		fwrite($fp, "ORGANIZER;CN=".trim($firstName)." ".trim($lastName).":mailto:".$email."\n");
		fwrite($fp, "UID:". md5("VGSEventsInvites".$record->getId()) ."\n");

		if(is_array($eventAttedants) && count($eventAttedants)>0){
			foreach ($eventAttedants as $attendantEmail) {
				fwrite($fp, "ATTENDEE;CUTYPE=INDIVIDUAL;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=" . $attendantEmail . ";X-NUM-GUESTS=0:mailto:" . $attendantEmail ."\n");
			}
		}
		
		fwrite($fp, "DTSTART;TZID=UTC:".date('Ymd\THis\Z', strtotime($record->get('date_start') .' '. $startTime)) ."\n");
		fwrite($fp, "DTEND;TZID=UTC:".date('Ymd\THis\Z', strtotime($record->get('due_date') .' '. $endTime)) ."\n");
		fwrite($fp, "DTSTAMP:".date('Ymd\THis\Z')."\n");
		fwrite($fp, "DESCRIPTION:".$record->get('description')."\nLOCATION:".$record->get('location')."\n");
		fwrite($fp, "SEQUENCE:".$seq."\n");
		fwrite($fp, "STATUS:CONFIRMED\nSUMMARY:".$record->get('subject')."\nEND:VEVENT\nEND:VCALENDAR");
		fclose($fp);
		
		return 'test/upload/'.$fileName.'.ics';
	}
	
	function getTimeZone($timezonecode){
		$timezones = array(
		            'Kwajalein'                    => '(UTC-12:00) International Date Line West',
		            'Pacific/Midway'               => '(UTC-11:00) Coordinated Universal Time-11',
		            'Pacific/Samoa'                => '(UTC-11:00) Samoa',
		            'Pacific/Honolulu'             => '(UTC-10:00) Hawaii',
		            'America/Anchorage'            => '(UTC-09:00) Alaska',
		            'America/Los_Angeles'          => '(UTC-08:00) Pacific Time (US &amp; Canada)',
		            'America/Tijuana'              => '(UTC-08:00) Tijuana, Baja California',
		            'America/Denver'               => '(UTC-07:00) Mountain Time (US &amp; Canada)',
		            'America/Chihuahua'            => '(UTC-07:00) Chihuahua, La Paz, Mazatlan',
		            'America/Mazatlan'             => '(UTC-07:00) Mazatlan',
		            'America/Phoenix'              => '(UTC-07:00) Arizona',
		            'America/Regina'               => '(UTC-06:00) Saskatchewan',
		            'America/Tegucigalpa'          => '(UTC-06:00) Central America',
		            'America/Chicago'              => '(UTC-06:00) Central Time (US &amp; Canada)',
		            'America/Mexico_City'          => '(UTC-06:00) Mexico City',
		            'America/Monterrey'            => '(UTC-06:00) Monterrey',
		            'America/New_York'             => '(UTC-05:00) Eastern Time (US &amp; Canada)',
		            'America/Bogota'               => '(UTC-05:00) Bogota, Lima, Quito',
		            'America/Lima'                 => '(UTC-05:00) Lima',
		            'America/Rio_Branco'           => '(UTC-05:00) Rio Branco',
		            'America/Indianapolis' => '(UTC-05:00) Indiana (East)',
		            'America/Caracas'              => '(UTC-04:30) Caracas',
		            'America/Halifax'              => '(UTC-04:00) Atlantic Time (Canada)',
		            'America/Manaus'               => '(UTC-04:00) Manaus',
		            'America/Santiago'             => '(UTC-04:00) Santiago',
		            'America/La_Paz'               => '(UTC-04:00) La Paz',
		            'America/Cuiaba'               => '(UTC-04:00) Cuiaba',
		            'America/Asuncion'             => '(UTC-04:00) Asuncion',
		            'America/St_Johns'             => '(UTC-03:30) Newfoundland',
		            'America/Buenos_Aires' => '(UTC-03:00) Buenos Aires',
		            'America/Sao_Paulo'            => '(UTC-03:00) Brasilia',
		            'America/Godthab'              => '(UTC-03:00) Greenland',
		            'America/Montevideo'           => '(UTC-03:00) Montevideo',
		            'Atlantic/South_Georgia'       => '(UTC-02:00) Mid-Atlantic',
		            'Atlantic/Azores'              => '(UTC-01:00) Azores',
		            'Atlantic/Cape_Verde'          => '(UTC-01:00) Cape Verde Is.',
		            'Europe/London'                => '(UTC) London, Edinburgh, Dublin, Lisbon',
		            'UTC'                          => '(UTC) Coordinated Universal Time, Greenwich Mean Time',
		            'Africa/Monrovia'              => '(UTC) Monrovia, Reykjavik',
		            'Africa/Casablanca'            => '(UTC) Casablanca',
		            'Europe/Belgrade'              => '(UTC+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague',
		            'Europe/Sarajevo'              => '(UTC+01:00) Sarajevo, Skopje, Warsaw, Zagreb',
		            'Europe/Brussels'              => '(UTC+01:00) Brussels, Copenhagen, Madrid, Paris',
		            'Africa/Algiers'               => '(UTC+01:00) West Central Africa',
		            'Europe/Amsterdam'             => '(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna',
		            'Europe/Minsk'                 => '(UTC+02:00) Minsk',
		            'Africa/Cairo'                 => '(UTC+02:00) Cairo',
		            'Europe/Helsinki'              => '(UTC+02:00) Helsinki, Riga, Sofia, Tallinn, Vilnius',
		            'Europe/Athens'                => '(UTC+02:00) Athens, Bucharest',
		            'Europe/Istanbul'              => '(UTC+02:00) Istanbul',
		            'Asia/Jerusalem'               => '(UTC+02:00) Jerusalem',
		            'Asia/Amman'                   => '(UTC+02:00) Amman',
		            'Asia/Beirut'                  => '(UTC+02:00) Beirut',
		            'Africa/Windhoek'              => '(UTC+02:00) Windhoek',
		            'Africa/Harare'                => '(UTC+02:00) Harare',
		            'Asia/Kuwait'                  => '(UTC+03:00) Kuwait, Riyadh',
		            'Asia/Baghdad'                 => '(UTC+03:00) Baghdad',
		            'Africa/Nairobi'               => '(UTC+03:00) Nairobi',
		            'Asia/Tehran'                  => '(UTC+03:30) Tehran',
		            'Asia/Tbilisi'                 => '(UTC+04:00) Tbilisi',
		            'Europe/Moscow'                => '(UTC+03:00) Moscow, Volgograd',
		            'Asia/Muscat'                  => '(UTC+04:00) Abu Dhabi, Muscat',
		            'Asia/Baku'                    => '(UTC+04:00) Baku',
		            'Asia/Yerevan'                 => '(UTC+04:00) Yerevan',
		            'Asia/Karachi'                 => '(UTC+05:00) Islamabad, Karachi',
		            'Asia/Tashkent'                => '(UTC+05:00) Tashkent',
		            'Asia/Kolkata'                 => '(UTC+05:30) Chennai, Kolkata, Mumbai, New Delhi',
		            'Asia/Colombo'                 => '(UTC+05:30) Sri Jayawardenepura',
		            'Asia/Katmandu'                => '(UTC+05:45) Kathmandu',
		            'Asia/Dhaka'                   => '(UTC+06:00) Dhaka',
		            'Asia/Almaty'                  => '(UTC+06:00) Almaty',
		            'Asia/Yekaterinburg'           => '(UTC+06:00) Ekaterinburg',
		            'Asia/Rangoon'                 => '(UTC+06:30) Yangon (Rangoon)',
		            'Asia/Novosibirsk'             => '(UTC+07:00) Novosibirsk',
		            'Asia/Bangkok'                 => '(UTC+07:00) Bangkok, Jakarta',
		            'Asia/Brunei'                  => '(UTC+08:00) Beijing, Chongqing, Hong Kong, Urumqi',
		            'Asia/Krasnoyarsk'             => '(UTC+08:00) Krasnoyarsk',
		            'Asia/Ulaanbaatar'             => '(UTC+08:00) Ulaan Bataar',
		            'Asia/Kuala_Lumpur'            => '(UTC+08:00) Kuala Lumpur, Singapore',
		            'Asia/Taipei'                  => '(UTC+08:00) Taipei',
		            'Australia/Perth'              => '(UTC+08:00) Perth',
		            'Asia/Irkutsk'                 => '(UTC+09:00) Irkutsk',
		            'Asia/Seoul'                   => '(UTC+09:00) Seoul',
		            'Asia/Tokyo'                   => '(UTC+09:00) Tokyo',
		            'Australia/Darwin'             => '(UTC+09:30) Darwin',
		            'Australia/Adelaide'           => '(UTC+09:30) Adelaide',
		            'Australia/Canberra'           => '(UTC+10:00) Canberra, Melbourne, Sydney',
		            'Australia/Brisbane'           => '(UTC+10:00) Brisbane',
		            'Australia/Hobart'             => '(UTC+10:00) Hobart',
		            'Asia/Vladivostok'             => '(UTC+10:00) Vladivostok',
		            'Pacific/Guam'                 => '(UTC+10:00) Guam, Port Moresby',
		            'Asia/Yakutsk'                 => '(UTC+10:00) Yakutsk',
		            'Etc/GMT-11'                   => '(UTC+11:00) Solomon Is., New Caledonia',
		            'Pacific/Fiji'                 => '(UTC+12:00) Fiji',
		            'Asia/Kamchatka'               => '(UTC+12:00) Kamchatka',
		            'Pacific/Auckland'             => '(UTC+12:00) Auckland',
		            'Asia/Magadan'                 => '(UTC+12:00) Magadan','(UTC+13:00) Nukualofa'
		        );
		
		$timezonekey = false;
		foreach ($timezones as $key => $value) {
			if($timezonecode==$value)
							$timezonekey=$key;
		}		
		
		return  $timezonekey;
	}
}
