<?php

/**
 * VGS Related Module Updates
 *
 *
 * @package        VGSRelModUpdates Module
 * @author         Conrado Maggi
 * @license        Comercial / VPL
 * @copyright      2014 VGS Global
 * @version        Release: 1.0
 */

class VGSCommentsMentions extends VTEventHandler
{

    function handleEvent($eventName, $entityData)
    {
        global $adb;
        if ($eventName == 'vtiger.entity.aftersave.final') {

            $moduleName = $entityData->getModuleName();

            if ($moduleName == 'ModComments') {

               // new
               preg_match_all("/@[a-z]+[ |\n|\r]/", $entityData->get("commentcontent"), $matches);

               $usernames = array();

               // entry 0 contains all names
               foreach($matches[0] as $match) {

                       // get rid of newlines and/or spaces
                       $usernames[] = trim(str_replace("@", '', $match));
               }

               $usernames = array_unique($usernames);
               // new ends

/*
                $commentcontent = explode(' ', $entityData->get("commentcontent"));

                $usernames = array();
                for ($i = 0; $i < count($commentcontent); $i++) {
                    if (strpos($commentcontent[$i], "@") !== false)
                        $usernames[] = str_replace("@", '', $commentcontent[$i]);
                }
*/
                for ($i = 0; $i < count($usernames); $i++) {

                    //IGNORAMOS INVALIDO
                    if ($usernames[$i] == "")
                        continue;

                    $usermodel = Users_Record_Model::getInstanceByName($usernames[$i]);

                    if ($usermodel->get('status') == 'Active') {
                        $email = $usermodel->get("email1");
                        $this->sendInvitation($email, $entityData);
                    }
                }
            }
        }
    }

    function sendInvitation($email, $entityData)
    {
        global $current_user, $mod_strings, $site_URL;
        require_once("vtlib/Vtiger/Mailer.php");

        //Datos desde
        $currentUserModel = Users_Record_Model::getCurrentUserModel();
        $userName = $currentUserModel->getName();
        $fromEmail = Emails_Record_Model::getFromEmailAddress();

        $RelatedRecordModel = Vtiger_Record_Model::getInstanceById($entityData->get("related_to"));
        $RelatedModule = $RelatedRecordModel->getModuleName();
        $RelatedId = $RelatedRecordModel->getId();
        $enlace = $site_URL . "index.php?module=$RelatedModule&view=Detail&record=$RelatedId";

        //ARMAMOS EL BODY SEGUN  modules/Calendar/CalendarCommon.php

        $subject = vtranslate('LBL_EMAIL_SUBJECT', 'VGSCommentsMentions');
        $body = vtranslate('LBL_EMAIL_BODY', 'VGSCommentsMentions');

        $body = sprintf($body, $enlace, $entityData->get("commentcontent"));

        $RelatedName = $RelatedRecordModel->getPotentialname();
	$body = $RelatedModule . ' '. $RelatedName. "/n/n".$body;

        $mail = new Vtiger_Mailer();
        $mail->IsHTML(true);
        $mail->ConfigSenderInfo($fromEmail, $userName);
        $mail->Subject = $subject;
        $mail->Body = $body;
        $mail->AddAddress($email);
        //Para que me envie el email tuve que agregar estas lineas
        $mail->Send(true);
    }
}
