<?php

require_once('vtlib/Vtiger/Link.php');

class VGSCommentsMentions {

    function vtlib_handler($moduleName, $eventType) {
        $adb = PearDatabase::getInstance();


        if ($eventType == 'module.postinstall') {
            $this->addHandler();
            $this->addLinks();
        } else if ($eventType == 'module.disabled') {
            $this->addHandler(false);
        } else if ($eventType == 'module.enabled') {
            $this->addHandler();
        } else if ($eventType == 'module.preuninstall') {
            Vtiger_Link::deleteAll(getTabId("VGSCommentsMentions"));
            require_once'vtlib/Vtiger/Module.php';
            require 'include/events/include.inc';
            $em = new VTEventsManager($adb);
            $em->unregisterHandler('VGSCommentsMentions');
            
        } else if ($eventType == 'module.preupdate') {
            Vtiger_Link::deleteAll(getTabId("VGSCommentsMentions"));
        } else if ($eventType == 'module.postupdate') {
            $this->addLinks();
        }
    }


    function addHandler($setToActive = true){
        $adb = PearDatabase::getInstance();
        require_once'vtlib/Vtiger/Module.php';
        require 'include/events/include.inc';
        
        if($setToActive){
            $em = new VTEventsManager($adb);
            $em->registerHandler('vtiger.entity.aftersave.final', 'modules/VGSCommentsMentions/handler/VGSCommentsMentionsHandler.php', 'VGSCommentsMentions');
        
            $em->setHandlerActive('VGSCommentsMentions');
        }else {
            $em->setHandlerInActive('VGSCommentsMentions');
        }

    }
    
    function addLinks(){

        include('vtigerversion.php');
        $version = explode('.', $vtiger_current_version)[0];

        if ($version > 6) {
                Vtiger_Link::addLink(getTabId("VGSCommentsMentions"), 'HEADERSCRIPT', 'VGSCommentsMentions', 'layouts/v7/modules/VGSCommentsMentions/resources/VGSCommentsMentions.js', '', 0, '');
            } else {
                Vtiger_Link::addLink(getTabId("VGSCommentsMentions"), 'HEADERSCRIPT', 'VGSCommentsMentions', 'layouts/vlayout/modules/VGSCommentsMentions/resources/VGSCommentsMentions.js', '', 0, '');
            }
    }
}
