<?php

class VDTabulation_TabButton_View extends Vtiger_IndexAjax_View
{
    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod("showTabButton");        
    }
    
    public function process(Vtiger_Request $request)
    {
        $mode = $request->get("mode");
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
        }
    }
    public function showTabButton(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);
        $db = PearDatabase::getInstance();
        $block_id = $request->get("block_id");
        $sql = "SELECT\n                    is_tab,\n                    parent_tab,\n                    blocklabel\n                FROM\n                    `vtiger_blocks`\n                LEFT JOIN `vd_tabulation` ON `vtiger_blocks`.`blockid` = `vd_tabulation`.`block_id`\n                WHERE\n                    `vtiger_blocks`.`blockid` = ?\n                LIMIT 0, 1";
        $rs = $db->pquery($sql, array($block_id));
        $is_tab = false;
        $parent_tab = "";
        if ($rs) {
            $row = $db->fetch_row($rs);
            if ($row["blocklabel"] == "LBL_ITEM_DETAILS") {
                exit;
            }
            if (0 < $row["is_tab"]) {
                $is_tab = true;
            }
            if (!empty($row["parent_tab"])) {
                $parent_tab = vtranslate("LBL_BLOCK_IS_CHILD_OF") . $row["parent_tab"];
            }
        }
        $viewer->assign("BLOCK_ID", $block_id);
        $viewer->assign("IS_TAB", $is_tab);
        $viewer->assign("PARENT_TAB", $parent_tab);
        $viewer->assign('SOURCE_MODULE', Vtiger_Block_Model::getInstance($block_id)->module->name);
        $viewer->assign("QUALIFIED_MODULE", "VDTabulation");
        echo $viewer->view("TabButton.tpl", "VDTabulation", true);
    }
}

?>