<?php

class VDTabulation_Edit_View extends Vtiger_IndexAjax_View
{
    protected $record = false;
    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod("showModuleEditView");        
    }
    public function process(Vtiger_Request $request)
    {
        $mode = $request->get("mode");
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
        }
    }    
    public function showModuleEditView(Vtiger_Request $request)
    {
        $record = $request->get("record");
        $moduleName = $request->get("related_module_name");
        $db = PearDatabase::getInstance();
        $sql = "SELECT COUNT(*) as _count FROM `vd_tabulation`\r\n                       WHERE `vd_tabulation`.`is_tab` = 1 AND `vd_tabulation`.`module_name` =? LIMIT 0,1";
        $rs = $db->pquery($sql, array($moduleName));
        if (0 < $db->num_rows($rs)) {
            $noofrows = $db->query_result($rs, 0, "_count");
            if ($noofrows < 2) {
                echo "NO_TAB";
                exit;
            }
        }
        $viewer = $this->getViewer($request);
        if (!empty($record) && $request->get("isDuplicate") == true) {
            $recordModel = $this->record ? $this->record : Vtiger_Record_Model::getInstanceById($record, $moduleName);
            $viewer->assign("MODE", "");
            $mandatoryFieldModels = $recordModel->getModule()->getMandatoryFieldModels();
            foreach ($mandatoryFieldModels as $fieldModel) {
                if ($fieldModel->isReferenceField()) {
                    $fieldName = $fieldModel->get("name");
                    if (Vtiger_Util_Helper::checkRecordExistance($recordModel->get($fieldName))) {
                        $recordModel->set($fieldName, "");
                    }
                }
            }
        } else {
            if (!empty($record)) {
                $recordModel = $this->record ? $this->record : Vtiger_Record_Model::getInstanceById($record, $moduleName);
                $viewer->assign("RECORD_ID", $record);
                $viewer->assign("MODE", "edit");
            } else {
                $recordModel = Vtiger_Record_Model::getCleanInstance($moduleName);
                $viewer->assign("MODE", "");
            }
        }
        if (!$this->record) {
            $this->record = $recordModel;
        }
        $moduleModel = $recordModel->getModule();
        $fieldList = $moduleModel->getFields();
        $requestFieldList = array_intersect_key($request->getAllPurified(), $fieldList);
        $relContactId = $request->get("contact_id");
        if ($relContactId && $moduleName == "Calendar") {
            $contactRecordModel = Vtiger_Record_Model::getInstanceById($relContactId);
            $requestFieldList["parent_id"] = $contactRecordModel->get("account_id");
        }
        foreach ($requestFieldList as $fieldName => $fieldValue) {
            $fieldModel = $fieldList[$fieldName];
            $specialField = false;
            if ($moduleName == "Calendar" && empty($record) && $fieldName == "time_start" && !empty($fieldValue)) {
                $specialField = true;
                $fieldValue = DateTimeField::convertToDBTimeZone($fieldValue)->format("H:i");
            }
            if ($moduleName == "Calendar" && empty($record) && $fieldName == "date_start" && !empty($fieldValue)) {
                $startTime = Vtiger_Time_UIType::getTimeValueWithSeconds($requestFieldList["time_start"]);
                $startDateTime = Vtiger_Datetime_UIType::getDBDateTimeValue($fieldValue . " " . $startTime);
                list($startDate, $startTime) = explode(" ", $startDateTime);
                $fieldValue = Vtiger_Date_UIType::getDisplayDateValue($startDate);
            }
            if ($fieldModel->isEditable() || $specialField) {
                $recordModel->set($fieldName, $fieldModel->getDBInsertValue($fieldValue));
            }
        }
        $recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceFromRecordModel($recordModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_EDIT);
        $picklistDependencyDatasource = Vtiger_DependencyPicklist::getPicklistDependencyDatasource($moduleName);
        $salutationFieldModel = Vtiger_Field_Model::getInstance('salutationtype', $recordModel->getModule());
        if ($salutationFieldModel) {
            $viewer->assign('SALUTATION_FIELD_MODEL', $salutationFieldModel);
        }
        $viewer->assign("PICKIST_DEPENDENCY_DATASOURCE", Vtiger_Functions::jsonEncode($picklistDependencyDatasource));
        $viewer->assign("RECORD_STRUCTURE_MODEL", $recordStructureInstance);
        $viewer->assign("RECORD_STRUCTURE", $recordStructureInstance->getStructure());
        $viewer->assign("MODULE", $moduleName);
        $viewer->assign("CURRENTDATE", date("Y-n-j"));
        $viewer->assign("USER_MODEL", Users_Record_Model::getCurrentUserModel());
        $viewer->assign("BLOCK_LIST", $moduleModel->getBlocks());
        $isRelationOperation = $request->get("relationOperation");
        if ($moduleName == "Products" || $moduleName == "Services") {
            $taxDetails = array();
            $recordTaxDetails = $recordModel->getTaxClassDetails();
            foreach ($recordTaxDetails as $taxInfo) {
                $taxName = $taxInfo["taxname"];
                $taxCheck = $taxName . "_check";
                if ($request->has($taxCheck) && $request->get($taxCheck)) {
                    if ($request->has($taxName)) {
                        $taxPercentage = $request->get($taxName);
                    } else {
                        if ($request->has($taxName . "_defaultPercentage")) {
                            $taxPercentage = $request->get($taxName . "_defaultPercentage");
                            $regions = array_keys($taxInfo["regions"]);
                            $regionValues = $request->get($taxName . "_regions");
                            foreach ($regions as $key) {
                                $taxInfo["regions"][$key]["value"] = $regionValues[$key]["value"];
                            }
                        }
                    }
                    $taxInfo["percentage"] = $taxPercentage;
                    $taxInfo["check_value"] = 1;
                }
                $taxDetails[$taxInfo["taxid"]] = $taxInfo;
            }
            $baseCurrenctDetails = $recordModel->getBaseCurrencyDetails();
            $viewer->assign("BASE_CURRENCY_NAME", "curname" . $baseCurrenctDetails["currencyid"]);
            $viewer->assign("BASE_CURRENCY_ID", $baseCurrenctDetails["currencyid"]);
            $viewer->assign("BASE_CURRENCY_SYMBOL", $baseCurrenctDetails["symbol"]);
            $viewer->assign("TAXCLASS_DETAILS", $taxDetails);
        }
        $viewer->assign("IS_RELATION_OPERATION", $isRelationOperation);
        if ($isRelationOperation) {
            $viewer->assign("SOURCE_MODULE", $request->get("sourceModule"));
            $viewer->assign("SOURCE_RECORD", $request->get("sourceRecord"));
        }
        echo $viewer->view("EditViewContentsInTab.tpl", "VDTabulation", true);
    }
}

?>