<?php

class VDTabulation_DetailViewAjax_View extends Vtiger_IndexAjax_View
{
    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod("showModuleDetailView");        
    }
    public function process(Vtiger_Request $request)
    {
        $mode = $request->get("mode");
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
        }
    }    
    public function showModuleDetailView(Vtiger_Request $request)
    {
        $inventory_list = array("Quotes", "SalesOrder", "Invoice", "PurchaseOrder");
        $recordId = $request->get("record");
        $moduleName = $request->get("related_module_name");
        $db = PearDatabase::getInstance();
        $sql = "SELECT COUNT(*) as count FROM `vd_tabulation`\r\n                       WHERE `vd_tabulation`.`module_name` =? LIMIT 0,1";
        $rs = $db->pquery($sql, array($moduleName));
        if (0 < $db->num_rows($rs)) {
            $row = $db->fetch_row($rs);
            if ($row["count"] < 2) {
                echo "NO_TAB";
                exit;
            }
        }
        $this_record = Vtiger_DetailView_Model::getInstance($moduleName, $recordId);
        $recordModel = $this_record->getRecord();
        $recordStrucure = Vtiger_RecordStructure_Model::getInstanceFromRecordModel($recordModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_DETAIL);
        $structuredValues = $recordStrucure->getStructure();
        $moduleModel = $recordModel->getModule();
        $viewer = $this->getViewer($request);
        $viewer->assign("RECORD", $recordModel);
        $viewer->assign("RECORD_STRUCTURE", $structuredValues);
        $viewer->assign("BLOCK_LIST", $moduleModel->getBlocks());
        $viewer->assign("USER_MODEL", Users_Record_Model::getCurrentUserModel());
        $viewer->assign("MODULE_NAME", $moduleName);
        $viewer->assign("MODULE", $request->getModule());
        $viewer->assign("IS_AJAX_ENABLED", $recordModel->isEditable());
        $picklistDependencyDatasource = Vtiger_DependencyPicklist::getPicklistDependencyDatasource($moduleName);
        $viewer->assign("PICKIST_DEPENDENCY_DATASOURCE", Vtiger_Functions::jsonEncode($picklistDependencyDatasource));
        $viewer->assign("IMAGE_DETAILS", $recordModel->getImageDetails());
        if (in_array($moduleName, $inventory_list)) {
            $this->showLineItemDetails($request);
        }
        if ($moduleName == "Products") {
            $baseCurrenctDetails = $recordModel->getBaseCurrencyDetails();
            $viewer->assign("BASE_CURRENCY_SYMBOL", $baseCurrenctDetails["symbol"]);
            $viewer->assign("TAXCLASS_DETAILS", $recordModel->getTaxClassDetails());
            $viewer->assign("IMAGE_DETAILS", $recordModel->getImageDetails());
        }
        echo $viewer->view("DetailViewTabsView.tpl", "VDTabulation", true);
    }
    /**
     * Function returns Inventory Line Items
     * @param Vtiger_Request $request
     */
    public function showLineItemDetails(Vtiger_Request $request)
    {
        $record = $request->get("record");
        $moduleName = $request->getModule();
        $recordModel = Inventory_Record_Model::getInstanceById($record);
        $relatedProducts = $recordModel->getProducts();
        $finalDetails = $relatedProducts[1]["final_details"];
        $taxtype = $finalDetails["taxtype"];
        if ($taxtype == "group") {
            $taxDetails = $finalDetails["taxes"];
            $taxCount = count($taxDetails);
            foreach ($taxDetails as $key => $taxInfo) {
                $taxDetails[$key]["amount"] = Vtiger_Currency_UIType::transformDisplayValue($taxInfo["amount"], NULL, true);
            }
            $finalDetails["taxes"] = $taxDetails;
        }
        $deductTaxes = $finalDetails["deductTaxes"];
        foreach ($deductTaxes as $taxId => $taxInfo) {
            $deductTaxes[$taxId]["taxAmount"] = Vtiger_Currency_UIType::transformDisplayValue($deductTaxes[$taxId]["taxAmount"], NULL, true);
        }
        $finalDetails["deductTaxes"] = $deductTaxes;
        $currencyFieldsList = array("adjustment", "grandTotal", "hdnSubTotal", "preTaxTotal", "tax_totalamount", "shtax_totalamount", "discountTotal_final", "discount_amount_final", "shipping_handling_charge", "totalAfterDiscount", "deductTaxesTotalAmount");
        foreach ($currencyFieldsList as $fieldName) {
            $finalDetails[$fieldName] = Vtiger_Currency_UIType::transformDisplayValue($finalDetails[$fieldName], NULL, true);
        }
        $relatedProducts[1]["final_details"] = $finalDetails;
        $productsCount = count($relatedProducts);
        for ($i = 1; $i <= $productsCount; $i++) {
            $product = $relatedProducts[$i];
            if ($taxtype == "individual") {
                $taxDetails = $product["taxes"];
                $taxCount = count($taxDetails);
                for ($j = 0; $j < $taxCount; $j++) {
                    $taxDetails[$j]["amount"] = Vtiger_Currency_UIType::transformDisplayValue($taxDetails[$j]["amount"], NULL, true);
                }
                $product["taxes"] = $taxDetails;
            }
            $currencyFieldsList = array("taxTotal", "netPrice", "listPrice", "unitPrice", "productTotal", "purchaseCost", "margin", "discountTotal", "discount_amount", "totalAfterDiscount");
            foreach ($currencyFieldsList as $fieldName) {
                $product[$fieldName . $i] = Vtiger_Currency_UIType::transformDisplayValue($product[$fieldName . $i], NULL, true);
            }
            $relatedProducts[$i] = $product;
        }
        $selectedChargesAndItsTaxes = $relatedProducts[1]["final_details"]["chargesAndItsTaxes"];
        if (!$selectedChargesAndItsTaxes) {
            $selectedChargesAndItsTaxes = array();
        }
        $shippingTaxes = array();
        $allShippingTaxes = getAllTaxes("all", "sh");
        foreach ($allShippingTaxes as $shTaxInfo) {
            $shippingTaxes[$shTaxInfo["taxid"]] = $shTaxInfo;
        }
        $selectedTaxesList = array();
        foreach ($selectedChargesAndItsTaxes as $chargeId => $chargeInfo) {
            if ($chargeInfo["taxes"]) {
                foreach ($chargeInfo["taxes"] as $taxId => $taxPercent) {
                    $taxInfo = array();
                    $amount = $calculatedOn = $chargeInfo["value"];
                    if ($shippingTaxes[$taxId]["method"] === "Compound") {
                        $compoundTaxes = Zend_Json::decode(html_entity_decode($shippingTaxes[$taxId]["compoundon"]));
                        if (is_array($compoundTaxes)) {
                            foreach ($compoundTaxes as $comTaxId) {
                                $calculatedOn += (double) $amount * (double) $chargeInfo["taxes"][$comTaxId] / 100;
                            }
                            $taxInfo["method"] = "Compound";
                            $taxInfo["compoundon"] = $compoundTaxes;
                        }
                    }
                    $calculatedAmount = (double) $calculatedOn * (double) $taxPercent / 100;
                    $taxInfo["name"] = $shippingTaxes[$taxId]["taxlabel"];
                    $taxInfo["percent"] = $taxPercent;
                    $taxInfo["amount"] = Vtiger_Currency_UIType::transformDisplayValue($calculatedAmount, NULL, true);
                    $selectedTaxesList[$chargeId][$taxId] = $taxInfo;
                }
            }
        }
        $selectedChargesList = Inventory_Charges_Model::getChargeModelsList(array_keys($selectedChargesAndItsTaxes));
        foreach ($selectedChargesList as $chargeId => $chargeModel) {
            $chargeInfo["name"] = $chargeModel->getName();
            $chargeInfo["amount"] = Vtiger_Currency_UIType::transformDisplayValue($selectedChargesAndItsTaxes[$chargeId]["value"], NULL, true);
            $chargeInfo["percent"] = $selectedChargesAndItsTaxes[$chargeId]["percent"];
            $chargeInfo["taxes"] = $selectedTaxesList[$chargeId];
            $chargeInfo["deleted"] = $chargeModel->get("deleted");
            $selectedChargesList[$chargeId] = $chargeInfo;
        }
        $viewer = $this->getViewer($request);
        $viewer->assign("RELATED_PRODUCTS", $relatedProducts);
        $viewer->assign("SELECTED_CHARGES_AND_ITS_TAXES", $selectedChargesList);
        $viewer->assign("RECORD", $recordModel);
    }
}

?>