<?php

require_once "modules/Settings/LayoutEditor/models/Module.php";
class VDTabulation_Module_Model extends Settings_LayoutEditor_Module_Model
{
    public function getSettingLinks()
    {
        $settingsLinks[] = array("linktype" => "MODULESETTING", "linklabel" => "Settings", "linkurl" => "index.php?module=VDTabulation&parent=Settings&view=Settings", "linkicon" => "");        
        $settingsLinks[] = array("linktype" => "MODULESETTING", "linklabel" => "Uninstall", "linkurl" => "index.php?module=VDTabulation&parent=Settings&view=Uninstall", "linkicon" => "");
        return $settingsLinks;
    }
    public static function checkIsTab($block_id)
    {
        $adb = PearDatabase::getInstance();
        $sql = "SELECT is_tab,parent_tab,(SELECT count(*) FROM \tvtiger_field WHERE\tvtiger_field.block = ? AND vtiger_field.presence != 1) as num_fields  FROM vd_tabulation WHERE block_id = ?";
        $result = $adb->pquery($sql, array($block_id, $block_id));
        $tab_info = array("is_tab_store" => 0, "parent_tab" => "");
        if (0 < $adb->num_rows($result)) {
            $is_tab_store = $adb->query_result($result, 0, "is_tab");
            $parent_tab = $adb->query_result($result, 0, "parent_tab");
            $num_fields = $adb->query_result($result, 0, "num_fields");
            $tab_info = array("is_tab_store" => $is_tab_store, "parent_tab" => $parent_tab, "num_fields" => $num_fields);
        }
        return $tab_info;
    }
    public static function getSettingsActiveBlock($viewName)
    {
    }
    public static function isChild($block_id)
    {
        $db = PearDatabase::getInstance();
        $sql = "SELECT * FROM vd_tabulation WHERE block_id = ?";
        $result = $db->pquery($sql, array($block_id));
        $is_child = false;
        if (0 < $db->num_rows($result)) {
            $parent_tab = $db->query_result($result, 0, "parent_tab");
            if (!empty($parent_tab)) {
                $is_child = true;
            }
        }
        return $is_child;
    }
    public static function getCombineTabs($module_name)
    {
        $db = PearDatabase::getInstance();
        $sql = "SELECT DISTINCT\r\n                    parent_tab,\r\n                    (\r\n                        SELECT\r\n                            count(*)\r\n                        FROM\r\n                            vd_tabulation tc\r\n                        WHERE\r\n                            tc.is_tab = 1\r\n                        AND tc.parent_tab = t.parent_tab\r\n                    ) AS _count\r\n                FROM\r\n                    vd_tabulation t\r\n                INNER JOIN vtiger_blocks b ON b.blockid = t.block_id\r\n                WHERE\r\n                    t.module_name = ?\r\n                AND t.parent_tab IS NOT NULL\r\n                AND t.parent_tab != ''\r\n                ORDER BY b.sequence ASC";
        $result = $db->pquery($sql, array($module_name));
        $array_tabs = array();
        if (0 < $db->num_rows($result)) {
            while ($row = $db->fetch_row($result)) {
                $count_child_tab = $row["_count"];
                if (0 < $count_child_tab) {
                    $randomId = self::randString(20);
                    $array_tabs[$randomId] = $row["parent_tab"];
                }
            }
        }
        return $array_tabs;
    }
    public static function getParent($parent_label, $module_name)
    {
        $db = PearDatabase::getInstance();
        $sql = "SELECT * FROM vd_tabulation";
        $result = $db->pquery($sql, array());
        $is_parent = false;
        if (0 < $db->num_rows($result)) {
            while ($row = $db->fetch_row($result)) {
                if (vtranslate($row["parent_tab"], $module_name) == vtranslate($parent_label, $module_name)) {
                    $is_parent = $row["block_id"];
                    break;
                }
            }
        }
        return $is_parent;
    }
    public function randString($length, $charset = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789")
    {
        $str = "";
        $count = strlen($charset);
        while ($length--) {
            $str .= $charset[mt_rand(0, $count - 1)];
        }
        return $str;
    }
    public static function getTabsLabelWithOrder($module_name)
    {
        $db = PearDatabase::getInstance();
        $sql = "SELECT  (CASE\r\n                        WHEN t.parent_tab IS NOT NULL AND t.parent_tab !='' THEN t.parent_tab\r\n                        ELSE b.blocklabel\r\n                    END) AS blocklabel\r\n                FROM\r\n                vtiger_blocks b\r\n                LEFT JOIN vd_tabulation t ON b.blockid = t.block_id\r\n                WHERE\r\n                    t.module_name = ?\r\n                AND t.is_tab = 1\r\n                ORDER BY\r\n                    b.sequence ASC";
        $result = $db->pquery($sql, array($module_name));
        $tabs_list = array();
        if (0 < $db->num_rows($result)) {
            while ($row = $db->fetch_row($result)) {
                if (!empty($row["blocklabel"])) {
                    $tabs_list[] = $row["blocklabel"];
                }
            }
        }
        return array_unique($tabs_list);
    }
    public static function getImageField($module_name)
    {
        $result = array();
        $fieldModel = Vtiger_Field_Model::getInstance('imagename', Vtiger_Module_Model::getInstance($module_name));
        if ($fieldModel->isActiveField()) {
            $result['imagename'] = $fieldModel;
        }
        return $result;
    }
    public static function getFieldModelTypeField($field, $module_name)
    {
        $result = false;
        $fieldModel = Vtiger_Field_Model::getInstance($field, Vtiger_Module_Model::getInstance($module_name));
        if ($fieldModel->isActiveField()) {
            $result = $fieldModel;
        }
        return $result;
    }
}

?>