<?php

class VDTabulation_ActionAjax_Action extends Vtiger_Action_Controller
{
    public function checkPermission(Vtiger_Request $request)
    {
        return true;
    }
    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod("switchToTab");
        $this->exposeMethod("combineTab");        
        $this->exposeMethod("getNameById");
        $this->exposeMethod("getRecordForCopy");
    }
    
    public function process(Vtiger_Request $request)
    {
        $mode = $request->get("mode");
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
        }
    }
    public function switchToTab(Vtiger_Request $request)
    {
        $db = PearDatabase::getInstance();
        $block_id = $request->get("block_id");
        $module_name = $request->get("module_name");
        $is_tab = $request->get("is_tab") == "on" || $request->get("is_tab") == 1 ? 1 : 0;
        $sql = "SELECT * FROM vd_tabulation WHERE block_id = ?";
        $result = $db->pquery($sql, array($block_id));
        if ($is_tab == 0) {
            $sql = "DELETE FROM `vd_tabulation` WHERE `block_id` =?";
            $result = $db->pquery($sql, array($block_id));
        } else {
            if (0 < $db->num_rows($result)) {
                $sql = "UPDATE `vd_tabulation` SET is_tab = ?\r\n                       WHERE `block_id` =?";
                $result = $db->pquery($sql, array($is_tab, $block_id));
            } else {
                $sql = "INSERT INTO vd_tabulation (is_tab,block_id,module_name)\r\n                  VALUES (?, ?,?);";
                $result = $db->pquery($sql, array($is_tab, $block_id, $module_name));
            }
        }
        if ($is_tab == 1) {
            $return = array("switch" => true, "massage" => vtranslate("LBL_TURN_ON_TAB", 'VDTabulation'));
        } else {
            $return = array("switch" => true, "massage" => vtranslate("LBL_TURN_OFF_TAB", 'VDTabulation'));
        }
        $response = new Vtiger_Response();
        $response->setEmitType(Vtiger_Response::$EMIT_JSON);
        $response->setResult($return);
        $response->emit();
    }
    public function combineTab(Vtiger_Request $request)
    {
        $db = PearDatabase::getInstance();
        $block_id = $request->get("block_id");
        $tab_name = trim($request->get("tab_name"));
        $module_name = $request->get("module_name");
        $tabsList = $request->get("tabs_list");
        if ($tabsList) {
            $tab_name = $tabsList;
        }
        $sql = "SELECT * FROM vd_tabulation WHERE block_id = ?";
        $result = $db->pquery($sql, array($block_id));
        if (0 < $db->num_rows($result)) {
            $sql = "UPDATE `vd_tabulation` SET parent_tab = ?,is_tab = 1\r\n                       WHERE `block_id` =?";
            $result = $db->pquery($sql, array($tab_name, $block_id));
        } else {
            $sql = "INSERT INTO vd_tabulation (parent_tab,block_id,is_tab,module_name) VALUES (?, ?,?,?);";
            $result = $db->pquery($sql, array($tab_name, $block_id, 1, $module_name));
        }
        $return = array("combine" => true, "message" => vtranslate("LBL_BLOCK_COMBINED_TO_TAB") . vtranslate($tab_name));
        $response = new Vtiger_Response();
        $response->setEmitType(Vtiger_Response::$EMIT_JSON);
        $response->setResult($return);
        $response->emit();
    }
    public function getNameById(Vtiger_Request $request)
    {
        $record = $request->get('record');
        $prop = $request->get('prop');
        $return = array('result' => Vtiger_Util_Helper::getRecordName($record), 'prop' => $prop);
        $response = new Vtiger_Response();
        $response->setEmitType(Vtiger_Response::$EMIT_JSON);
        $response->setResult($return);
        $response->emit();
    }
    public function getRecordForCopy(Vtiger_Request $request)
    {
        $record = $request->get('record');
        $parentModule = $request->get('parent');
        $response = new Vtiger_Response();
        $response->setEmitType(Vtiger_Response::$EMIT_JSON);
        if ($record > 0) {
            $recordModel = Vtiger_Record_Model::getInstanceById($record, $parentModule);
            if ($recordModel) {
                $response->setResult(array('result' => $recordModel->getData()));
            } else {
                $response->setError('404', 'Record Not Found');
            }
        } else {
            $response->setError('404', 'Record Not Found');
        }
        $response->emit();
    }
}

?>