<?php

require_once "data/CRMEntity.php";
require_once "data/Tracker.php";
require_once "vtlib/Vtiger/Module.php";
class VDTabulation extends CRMEntity
{
    /**
     * Invoked when special actions are performed on the module.
     * @param String Module name
     * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall).
     */
    public function vtlib_handler($modulename, $event_type)
    {
        if ($event_type == "module.postinstall") {
            self::addWidgetTo();            
        } else {
            if ($event_type == "module.disabled") {
                self::removeWidgetTo();
            } else {
                if ($event_type == "module.enabled") {
                    self::addWidgetTo();
                } else {
                    if ($event_type == "module.preuninstall") {
                        self::removeWidgetTo();                        
                    } else {
                        if ($event_type == "module.preupdate") {
                        } else {
                            if ($event_type == "module.postupdate") {
                                self::removeWidgetTo();
                                self::addWidgetTo();                                
                            }
                        }
                    }
                }
            }
        }
    }    
    /**
     * Add header script to other module.
     * @return unknown_type
     */
    public static function addWidgetTo()
    {
        global $adb;
        global $vtiger_current_version;
        $widgetType = "HEADERSCRIPT";
        $widgetName = "VDTabulation";
        $template_folder = "layouts/v7";
        $link = $template_folder . "/modules/VDTabulation/resources/VDTabulation.js";
        include_once "vtlib/Vtiger/Module.php";
        $moduleNames = array("VDTabulation");
        foreach ($moduleNames as $moduleName) {
            $module = Vtiger_Module::getInstance($moduleName);
            if ($module) {
                $module->addLink($widgetType, $widgetName, $link);
            }
        }
        $max_id = $adb->getUniqueID("vtiger_settings_field");
        $adb->pquery("INSERT INTO `vtiger_settings_field` (`fieldid`, `blockid`, `name`, `description`, `linkto`, `sequence`) VALUES (?, ?, ?, ?, ?, ?)", array($max_id, "4", "ExtraTabs", "Settings area for VDTabulation", "index.php?module=VDTabulation&parent=Settings&view=Settings", $max_id));
    }
    public static function removeWidgetTo()
    {
        global $adb;
        $widgetType = "HEADERSCRIPT";
        $widgetName = "VDTabulation";
        $template_folder = "layouts/v7";
        $link = $template_folder . "/modules/VDTabulation/resources/VDTabulation.js";
        include_once "vtlib/Vtiger/Module.php";
        $moduleNames = array("VDTabulation");
        foreach ($moduleNames as $moduleName) {
            $module = Vtiger_Module::getInstance($moduleName);
            if ($module) {
                $module->deleteLink($widgetType, $widgetName, $link);
            }
        }
        $adb->pquery("DELETE FROM vtiger_settings_field WHERE blockid = ? AND name = ? AND description = ? AND linkto = ?", array("4", "ExtraTabs", "Settings area for VDTabulation", "index.php?module=VDTabulation&parent=Settings&view=Settings"));
    }
}

?>