<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

vimport('~~/vtlib/Vtiger/Net/Client.php');
class Users_Login_View extends Vtiger_View_Controller {

	function loginRequired() {
		return false;
	}
	
	function checkPermission(Vtiger_Request $request) {
		return true;
	}
	
	function preProcess(Vtiger_Request $request, $display = true) {
		$viewer = $this->getViewer($request);
		$viewer->assign('PAGETITLE', $this->getPageTitle($request));
		$viewer->assign('SCRIPTS', $this->getHeaderScripts($request));
		$viewer->assign('STYLES', $this->getHeaderCss($request));
		$viewer->assign('MODULE', $request->getModule());
		$viewer->assign('VIEW', $request->get('view'));

		// @change txxxx translate login page
		// $viewer->assign('LANGUAGE_STRINGS', array());
		$viewer->assign('LANGUAGE_STRINGS', $this->getJSLanguageStrings($request));
		$viewer->assign('LANGUAGE', VtigerConfig::get('default_language'));
		//

		if ($display) {
			$this->preProcessDisplay($request);
		}
	}

	function process (Vtiger_Request $request) {
		$finalJsonData = array();

		$modelInstance = Settings_ExtensionStore_Extension_Model::getInstance();
		$news = $modelInstance->getNews();

		if ($news && $news['result']) {
			$jsonData = $news['result'];
			$oldTextLength = vglobal('listview_max_textlength');
			foreach ($jsonData as $blockData) {
				if ($blockData['type'] === 'feature') {
					$blockData['heading'] = "What's new in Vtiger Cloud";
				} else if ($blockData['type'] === 'news') {
					$blockData['heading'] = "Latest News";
					$blockData['image'] = '';
				}

				vglobal('listview_max_textlength', 80);
				$blockData['displayTitle'] = textlength_check($blockData['title']);

				vglobal('listview_max_textlength', 200);
				$blockData['displaySummary'] = textlength_check($blockData['summary']);
				$finalJsonData[$blockData['type']][] = $blockData;
			}
			vglobal('listview_max_textlength', $oldTextLength);
		}

		$viewer = $this->getViewer($request);
		$viewer->assign('DATA_COUNT', count($jsonData));
		$viewer->assign('JSON_DATA', $finalJsonData);

		$mailStatus = $request->get('mailStatus');
		$error = $request->get('error');
		$message = '';
		if ($error) {
			switch ($error) {
				case 'login':
					$message = vtranslate('Invalid credentials', 'Users');
					break;

				case 'fpError':
					$message = vtranslate('Invalid Username or Email address', 'Users');
					break;

				case 'statusError':
					$message = vtranslate('Outgoing mail server was not configured', 'Users');
					break;

				// 2FA: Start
				case 'gacodeempty':

					$message = vtranslate('Please enter Authenticator Code', 'MFALogin.php');
					break;

				case 'gacodeerror':

					$message = vtranslate('Invalid Authenticator Code', 'MFALogin.php');
					break;
				// 2FA: End

				// @change SecurityManager
				case 'blocked':
					$message = vtranslate('Login is blocked. Please retry later', 'SecurityManager');
					break;
				//
			}
		}
		else if ($mailStatus) {

			$message = vtranslate('Mail has been sent to your inbox, please check your e-mail', 'Users');
		}

		$viewer->assign('ERROR', $error);
		$viewer->assign('MESSAGE', $message);
		$viewer->assign('MAIL_STATUS', $mailStatus);

		// @change customizing
		$viewer->assign('LIQUIDSERVER', $this->testLiquidServer());
		//

		// @change t44386
		$viewer->assign('CLIENTDATA', $this->getClientData());
		//

		// @change MFA-login
		// $viewer->view('Login.tpl', 'Users');
		$viewer->view('Login.tpl', 'MFAuthorisation');
		//
	}

	// @change t44386
	function getClientData() {

		$siteUrl = VtigerConfig::get('site_URL');
		$currentVersion = VtigerConfig::get('vtiger_current_version');
		$applicationKey = VtigerConfig::get('application_unique_key');

		return sprintf("sr=%s&bn=1&bp=1&bt=vthome&sv=1.0&vtv=%s&uid=%s", $siteUrl, $currentVersion, $applicationKey);
	}
	//

	// @change customizing
	function testLiquidServer() {

		$curl = curl_init('https://liquidserver.vicus.nl/alive.php');
		curl_setopt($curl, CURLOPT_HEADER, 0);
                
		// @change t45555
		curl_setopt($curl, CURLOPT_TIMEOUT, 4);
		curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 4);
		//

		curl_exec($curl);
		$info = curl_getinfo($curl);
		curl_close($curl);

		return ($info['http_code'] == 200);
	}
	//

	function postProcess(Vtiger_Request $request) {
		$moduleName = $request->getModule();
		$viewer = $this->getViewer($request);
		$viewer->view('Footer.tpl', $moduleName);
	}

	function getPageTitle(Vtiger_Request $request) {
		$companyDetails = Vtiger_CompanyDetails_Model::getInstanceById();
		return $companyDetails->get('organizationname');
	}

	function getHeaderScripts(Vtiger_Request $request){
		$headerScriptInstances = parent::getHeaderScripts($request);

		$jsFileNames = array(
					// @change t33313
					// '~libraries/jquery/boxslider/jquery.bxslider.min.js',
					// '~libraries/jquery/bxslider-4-master/src/js/jquery.bxslider.js',
					'~libraries/jquery/bxslider-4-4.2.15/jquery.bxslider.min.js',
					//

					'modules.Vtiger.resources.List',
					'modules.Vtiger.resources.Popup');

		$jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
		$headerScriptInstances = array_merge($jsScriptInstances,$headerScriptInstances);
		return $headerScriptInstances;
	}
}
