<?php

include_once "GoogleAuthenticator.php";

class Users_ConnectionsSetup_Helper
{

    public function getGoogleAuthenticatorSecret($username = null){
        global $adb, $current_user;
        $user_id = $current_user->id;
        if(!$user_id){
            if($username){
                $userData = $this->getUserByName($username);
                if($userData)
                    $user_id = $userData['id'];
            }
        }
        if(!$user_id)
            return false;

        $secret = false;
        $secret_res = $adb->pquery("SELECT * FROM vtiger_users WHERE id = ?", array($user_id));
        if($adb->num_rows($secret_res)){
            $secret = $adb->query_result($secret_res, 0, 'ga_secret');
        }
        if(!$secret){
            $ga = new GoogleAuthenticator();
            $secret = $ga->createSecret();
            $adb->pquery("UPDATE vtiger_users SET ga_secret = ? WHERE id = ?", array($secret, $user_id));
        }
        return $secret;
    }

    public function getGoogleAuthenticatorQRCodeUrl(){
        global $current_user;
        $website = vglobal('site_URL');
        $moduleModel = Settings_Vtiger_CompanyDetails_Model::getInstance();
        $company = $moduleModel->get('organizationname');
        $title = $company . " username " . $current_user->user_name;
        $secret = $this->getGoogleAuthenticatorSecret();
        $ga = new GoogleAuthenticator();
        $url = $ga->getQRCodeGoogleUrl($website, $secret, $title);
        return $url;
    }

    public function verifyGoogleAuthenticatorCode($code, $username = null){
        $ga = new GoogleAuthenticator();
        $secret = $this->getGoogleAuthenticatorSecret($username);
        if(!$secret)
            return false;

        $verify = $ga->verifyCode($secret, $code, 20);
        return $verify;
    }


    public function isGAUserPreferenceEnable($username = null, $user_id = null){
        global $current_user;
        if(!$user_id)
            $user_id = $current_user->id;

        if($user_id){
            $userData = $this->getUserById($user_id);
        } else {
            if(!$username)
                return false;

            $userData = $this->getUserByName($username);
        }

        if(!$userData)
            return false;

        return $userData['is_ga_enable'] == '1'? true : false;
    }

    public function getUserByName($username){
        global $adb;
        $res = $adb->pquery("SELECT * FROM vtiger_users WHERE user_name = ?", array($username));
        if($adb->num_rows($res)){
            return $adb->query_result_rowdata($res, 0);
        }
        return false;
    }

    public function getUserById($id){
        global $adb;
        $res = $adb->pquery("SELECT * FROM vtiger_users WHERE id = ?", array($id));
        if($adb->num_rows($res)){
            return $adb->query_result_rowdata($res, 0);
        }
        return false;
    }

    public function updateGA($fieldname,$value,$userid){
        global  $adb;
        if($userid != ''){
            $adb->pquery("UPDATE vtiger_users SET ".$fieldname." = ? WHERE id = ?", array($value, $userid));
        }

    }
}