<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

class Users_Login_Action extends Vtiger_Action_Controller {

	function loginRequired() {
		return false;
	}

	function checkPermission(Vtiger_Request $request) {
		return true;
	} 

	function process(Vtiger_Request $request) {

		$username = $request->get('username');
		$password = $request->getRaw('password');

		// TECHNOKRAFTS START
		$checkBlocked = Settings_BruteForce_Module_Model::checkBlocked();
		$bruteForceSettings = Settings_BruteForce_Module_Model::getBruteForceSettings();
		
		if ($checkBlocked && $bruteForceSettings['active']) {
		  Settings_BruteForce_Module_Model::sendNotificationEmail();
		  header('Location: index.php?module=Users&parent=Settings&view=Login&error=blocked');
		  exit;
		}
		// TECHNOKRAFTS END

		$user = CRMEntity::getInstance('Users');
		$user->column_fields['user_name'] = $username;
		
// 2FA: Start
$connectionHelper = new Users_ConnectionsSetup_Helper();
$ga_enable = $connectionHelper->isGAUserPreferenceEnable($username);
if($ga_enable){
        $ga_code = $request->get('code');
        if(!$ga_code){
                header ('Location: index.php?module=Users&parent=Settings&view=Login&error=gacodeempty');
                exit;
        }
        $verify = $connectionHelper->verifyGoogleAuthenticatorCode($ga_code, $username);
        if(!$verify){
                header ('Location: index.php?module=Users&parent=Settings&view=Login&error=gacodeerror');
                exit;
        }
}
// 2FA: End

		// TECHNOKRAFTS START
		$moduleModel = Users_Module_Model::getInstance('Users');
		// TECHNOKRAFTS END
		if ($user->doLogin($password)) {
			session_regenerate_id(true); // to overcome session id reuse.

			$userid = $user->retrieve_user_id($username);
			Vtiger_Session::set('AUTHUSERID', $userid);

			// For Backward compatability
			// TODO Remove when switch-to-old look is not needed
			$_SESSION['authenticated_user_id'] = $userid;
			$_SESSION['app_unique_key'] = vglobal('application_unique_key');
			$_SESSION['authenticated_user_language'] = vglobal('default_language');

			//Enabled session variable for KCFINDER 
			$_SESSION['KCFINDER'] = array(); 
			$_SESSION['KCFINDER']['disabled'] = false; 
			$_SESSION['KCFINDER']['uploadURL'] = "test/upload"; 
			$_SESSION['KCFINDER']['uploadDir'] = "../test/upload";
			$deniedExts = implode(" ", vglobal('upload_badext'));
			$_SESSION['KCFINDER']['deniedExts'] = $deniedExts;
			// End
			// TECHNOKRAFTS START
			$checkForcechange = Settings_Password_Module_Model::checkForcechange($userid);

			//Track the login History
			$moduleModel = Users_Module_Model::getInstance('Users');
			$moduleModel->saveLoginHistory($user->column_fields['user_name']);
			//End
						
			
              	if(isset($_SESSION['return_params'])){ 
				$return_params = urldecode($_SESSION['return_params']);
				header("Location: index.php?$return_params");
				exit();
			} else {
				if ($checkForcechange){
					header ('Location: index.php?module=Users&view=Forcechange&record='.$userid);	
				}
				else {
					header ('Location: index.php?module=Users&parent=Settings&view=SystemSetup');
				}

				exit();
			}

		} else {
			$browser = Settings_BruteForce_Module_Model::browserDetect();
			$moduleModel->saveLoginHistory($username, 'Failed login', $browser);
			header ('Location: index.php?module=Users&parent=Settings&view=Login&error=login');
			exit;
		}
	}
}
