<?php
/**
 * Created by Stefan Warnat
 * User: Stefan
 * Date: 16.08.2017
 * Time: 12:16
 */

namespace SubscribersList;


class TypeList
{
    private static $_Types = array();

    /**
     * @return array
     */
    public static function getTypes() {

        if(count(self::$_Types) === 0) {
            $alle = glob(dirname(__FILE__).'/../../extends/types/*');
            foreach($alle as $datei) {
                if (is_dir($datei) && file_exists($datei . DS . 'manifest.json')) {
                    $typeKey = basename($datei);
                    $type = self::getType($typeKey);

                    if($type === false) {
                        continue;
                    }

                    self::$_Types[$typeKey] = $type;
                }
            }
        }

        return self::$_Types;
    }

    /**
     * @param $typeKey
     * @return Type|boolean
     */
    public static function getType($typeKey) {
        if(!empty(self::$_Types[$typeKey])) {
            return self::$_Types[$typeKey];
        }

        $filePath = dirname(__FILE__).'/../../extends/types/' . $typeKey . DS . $typeKey . '.php';

        if(!file_exists($filePath)) {
            return false;
        }

        require_once($filePath);
        $className = '\\SubscribersList\\Types\\'.$typeKey;

        /**
         * @var $type Type
         */
        $type = new $className();
        $type->init();

        return $type;
    }

}