<?php
/**
 * Created by Stefan Warnat
 * User: Stefan
 * Date: 16.08.2017
 * Time: 12:17
 */

namespace SubscribersList;


use SubscribersList\Models\Container;
use SubscribersList\Models\Item;

abstract class Type
{
    protected $_TypeKey = null;

    protected $_PresetManager = null;

    protected $DefaultSettings = array();

    /**
     * @var Item
     */
    private $_CurrentItem = null;

    /**
     * @var Container
     */
    private $_CurrentContainer = null;

    public function __construct() {
        $this->_TypeKey = substr(strrchr(get_class($this), '\\'), 1);

        $this->_PresetManager = new PresetManager($this);
    }

    public function setContainer(Container $container) {
        $this->_CurrentContainer = $container;
    }
    public function getContainer() {
        return $this->_CurrentContainer;
    }

    private $_Manifest = array();

    public function isItemEvent() {
        return $_REQUEST['view'] == 'ItemEvent' && !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
    }
    public function getFrontendJSFiles() {
        $manifest = $this->getManifest();
        $frontendJS = $manifest['frontend_js'];

        $baseFiles = $this->_getFrontendJSFiles();
        if(empty($frontendJS)) {
            return $baseFiles;
        }

        $baseFiles[] = $this->getRelativePath().$frontendJS;
        return $baseFiles;
    }

    public function getFrontendCSSFiles() {
        $manifest = $this->getManifest();
        $frontendCSS = $manifest['frontend_css'];

        $baseFiles = $this->_getFrontendCSSFiles();
        if(empty($frontendCSS)) {
            return $baseFiles;
        }

        $baseFiles[] = $this->getRelativePath().$frontendCSS;
        return $baseFiles;
    }

    public function setItem(Item $item) {
        $this->_CurrentItem = $item;
    }

    /**
     * @return Item
     */
    protected function getItem() {
        return $this->_CurrentItem;
    }

    public function getDefaultSettings() {
        return $this->DefaultSettings;
    }

    public function getManifest() {
        if(empty($this->_Manifest)) {
            $filePath = DASHBOARD_EXTENDS_DIR . 'types' . DS . $this->_TypeKey . DS . 'manifest.json';

            $defaultManifest = array(
                'template_dir' => 'templates',
                'configuration_tpl' => 'Configuration.tpl',
            );

            $this->_Manifest = VtUtils::array_merge_recursive_distinct($defaultManifest, json_decode(file_get_contents($filePath), true));
        }

        return $this->_Manifest;
    }

    public function getDescription() {
        $manifest = $this->getManifest();
        if(empty($manifest['description'])) {
            return vtranslate('No description', 'SubscribersList');
        }
        return vtranslate($manifest['description'], 'SubscribersList');
    }

    public function getTypeUrl() {
        return vglobal('site_URL').'/'.$this->getRelativePath();
    }
    public function getTypePath() {
        return vglobal('root_directory').DS.$this->getRelativePath();
    }
    public function getRelativePath() {
        return 'modules/SubscribersList/extends/types/'.$this->_TypeKey.'/';
    }
    public function getPreviewImageSrc() {
        return $this->getTypeUrl().'image.png';
    }

    public function getTitle() {
        $manifest = $this->getManifest();
        if(empty($manifest['title'])) {
            return vtranslate('Unnamed Type', 'SubscribersList');
        }
        return vtranslate($manifest['title'], 'SubscribersList');
    }

    public function getPreviewHTML() {
        return 'PREVIEW HTML';
    }

    public function execute(Item $item, Container $container, $action, $options = array()) {
        $methodName = 'handler_'.strtolower($action);

        $this->setItem($item);
        $this->setContainer($container);

        if(method_exists($this, $methodName) === true) {
            return $this->$methodName($options);
        }

        return '';
    }

    public function getHTML(Item $item, $page = 1) {
        return '';
    }

    public function getConfigurationTpl() {
        $manifest = $this->getManifest();

        return DASHBOARD_EXTENDS_DIR . 'types' . DS . $this->_TypeKey . DS . $manifest['template_dir'] . DS . $manifest['configuration_tpl'];
    }

    /**
     * @return string
     */
    public function getConfigurationHTML(Item $item) {
        $tplFile = $this->getConfigurationTpl();

        $viewer = new \Vtiger_Viewer();

        $this->beforeConfiguration($viewer, $item);

        $data = $this->getManifest();

        $jsFile = array();
        $cssFiles = array();
        $jsFile = array_merge($jsFile, $this->_PresetManager->getJavaScriptFiles());
        $cssFiles = array_merge($cssFiles, $this->_PresetManager->getCSSFiles());

        $content = '';
        if(!empty($data['backend_js'])) {
            $jsFile[] = 'modules/SubscribersList/extends/types/'.$this->_TypeKey.'/' . $data['backend_js'].'?v='.date('Y-m-d-H-i-s');
        }
        if(!empty($data['frontend_js'])) {
            $jsFile[] = 'modules/SubscribersList/extends/types/'.$this->_TypeKey.'/' . $data['frontend_js'].'?v='.date('Y-m-d-H-i-s');
        }
        if(!empty($data['backend_css'])) {
            $cssFiles[] = 'modules/SubscribersList/extends/types/'.$this->_TypeKey.'/' . $data['backend_css'].'?v='.date('Y-m-d-H-i-s').'';
        }
        if(!empty($data['frontend_css'])) {
            $cssFiles[] = 'modules/SubscribersList/extends/types/'.$this->_TypeKey.'/' . $data['frontend_css'].'?v='.date('Y-m-d-H-i-s').'';
        }

        foreach($jsFile as $file) {
            $content .= '<script type="text/javascript" src="'.$file.'"></script>';
        }
        foreach($cssFiles as $file) {
            $content .= '<link rel="stylesheet" href="'.$file.'" type="text/css" media="screen" />';
        }

        $InlineJS = $this->_PresetManager->getInlineJavaScript();
        if(!empty($InlineJS)) {
            $content .= '<script type="text/javascript">'.$InlineJS.'</script>';
        }

        $this->applyPreset("beforeGetConfiguration", array($item, $viewer));

        $viewer->assign('SETTINGS', $item->getAll());

        $content .= $viewer->fetch($tplFile);

        return $content;
    }

    /**
     * Apply a presset
     *
     * @param $event
     * @param $values
     * @return mixed
     */
    public function applyPreset($event, $values) {
        $values = $this->_PresetManager->trigger($event, $values);

        return $values;
    }

    public function getTypeKey() {
        return $this->_TypeKey;
    }
    public function init() {

    }

    /**
     * Register Preset for this TaskType
     * Currently available presets: Condition, FieldSetter
     *
     * @param string $preset
     * @param string $configName name of configuration variable
     * @param array $extraParameter Parameter transfer to the preset
     * @see https://support.stefanwarnat.de
     * @return mixed
     */
    public function addPreset($preset, $configName, $extraParameter = array()) {
        $return = $this->_PresetManager->addPreset($preset, $configName, $extraParameter);
        return $return;
    }

    public function beforeConfiguration(\Vtiger_Viewer $viewer, Item $item) {}
    public function getTypePreviewExtra(Item $item) {}
    public function beforeSave($settings) { return $settings; }

    public function _getFrontendJSFiles() { return array(); }
    public function _getFrontendCSSFiles() { return array(); }
    public function _getBackendJSFiles() { return array(); }
    public function _getBackendCSSFiles() { return array(); }

    abstract function handler_run($options);

}