<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Stefan Warnat <support@stefanwarnat.de>
 * Date: 01.03.14 18:18
 * You must not use this file without permission.
 */
namespace SubscribersList;

class Preset {
    protected $field = false;
    protected $parameter = false;

    protected $_inlineJS = '';
    protected $_JSFiles = array();
    protected $_CSSFiles = array();

    public function __construct($field, $extraParameter = array()) {
        $this->field = $field;
        $this->parameter = $extraParameter;

        $this->init();
    }

    public function setParameter($key, $value) {
        if(is_array($this->parameter)) {
            $this->parameter = array();
        }

        $this->parameter[$key] = $value;
    }

    /**
     * @return string
     */
    public function getInlineJS() {
        return $this->_inlineJS;
    }

    /**
     * @return array
     */
    public function getJSFiles() {
        return $this->_JSFiles;
    }
    /**
     * @return array
     */
    public function getCSSFiles() {
        return $this->_CSSFiles;
    }

    public function addInlineJS($script) {
        $this->_inlineJS .= $script;
    }

    public function afterSave() { }
    public function beforeSave($data) { return $data; }
    public function beforeGetConfiguration($data) { return $data; }
    public function init() {}
}

?>