<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Stefan Warnat <support@stefanwarnat.de>
 * Date: 20.09.14 23:15
 * You must not use this file without permission.
 */
namespace EmailCampaigns\Plugins\RecordSource;

use EmailCampaigns\ComplexeCondition;
use EmailCampaigns\Preset;
use EmailCampaigns\PresetManager;
use EmailCampaigns\RelationAddExtend;
use EmailCampaigns\VTTemplate;

class CustomView extends \EmailCampaigns\RecordSource {


    public function getSource($moduleName) {

        $return = array(
            'id' => 'customview',
            'title' => 'Records from List Filter',
            'sort' => 20,
        );

        return $return;
    }

    /**
     * @param $key
     * @param $value
     * @param $context \Workflow\VTEntity
     * @return array|void
     */
    public function getQuery($sortField = null, $limit = null, $includeAllModTables = false) {
        $queryGenerator = new \QueryGenerator($this->_TargetModule, \Users::getActiveAdminUser());
        $queryGenerator->initForCustomViewById($this->_Data['customview']);
        $query = $queryGenerator->getQuery();
        $parts = preg_split('/FROM/i', $query);
        $query = 'SELECT vtiger_crmentity.crmid /* Insert Fields */ FROM '.$parts[1];

        $parts = preg_split('/ WHERE /i', $query);
        $query = $parts[0].' /* Insert Tables */ WHERE '.$parts[1];

        return $query;
    }

    public function beforeGetTaskform($data) {
        //var_dump('asd');
        //$presetManager = new PresetManager($this->)
    }

    /**
     * @var null|ComplexeCondition
     */
    private $_ConditionObj = null;

    public function getConfigHTML($data, $parameter) {

        $allviews = \CustomView_Record_Model::getAll($this->_TargetModule);
        $html = '<div style="margin:0 20px;"><label>'.vtranslate('Records from this Filter', 'Settings:Workflow2').':</label><select name="settings[recordsource][customview]" style="width:400px;">';

        if(!empty($this->_Data['customview'])) {
            $currentSelection = $this->_Data['customview'];
        } else {
            $currentSelection = '';
        }

        foreach($allviews as $view) {
            $html .= '<option value="'.$view->get('cvid').'" '.($view->get('cvid')==$currentSelection?'selected="selected"':'').'>'.$view->get('viewname').' ['.$view->getOwnerName().']</option>';
        }

        $html .= '</select><p>';

        $html .= '</div>';

        return $html;

    }
    public function getConfigInlineJS() {
        return '';
    }
    public function getConfigInlineCSS() {
        return '.asd { color:red; }';
    }

}

\EmailCampaigns\RecordSource::register('customview', '\EmailCampaigns\Plugins\RecordSource\CustomView');