<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Stefan Warnat <support@stefanwarnat.de>
 * Date: 20.09.14 23:15
 * You must not use this file without permission.
 */
namespace EmailCampaigns\Plugins\RecordSource;

use EmailCampaigns\ComplexeCondition;
use EmailCampaigns\PresetManager;
use EmailCampaigns\VTEntity;
use EmailCampaigns\VtUtils;

class Condition extends \EmailCampaigns\RecordSource {


    public function getSource($moduleName) {

        $return = array(
            'id' => 'condition',
            'title' => 'get Records by Condition',
            'sort' => 10,
            'options' => array(
                'condition' => array(
                    'type' => 'condition',
                    'label' => 'Define condition'
                )
            )
        );

        return $return;
    }

    /**
     * @param $key
     * @param $value
     * @param $context \EmailCampaigns\VTEntity
     * @return array|void
     */
    public function getQuery($sortField = null, $limit = null, $includeAllModTables = false) {

        $objMySQL = new \EmailCampaigns\ConditionMysql($this->_TargetModule, VTEntity::getDummy());
//        $objMySQL->setLogger($logger);

        $main_module = \CRMEntity::getInstance($this->_TargetModule);
        #$sqlTables = $main_module->generateReportsQuery($related_module);

        $sqlCondition = $objMySQL->parse($this->_Data['recordsourcecondition']);

        $sqlTables = $objMySQL->generateTables($includeAllModTables);

        if(strlen($sqlCondition) > 3) {
            $sqlCondition .= " AND vtiger_crmentity.deleted = 0";
        } else {
            $sqlCondition .= " vtiger_crmentity.deleted = 0";
        }

        $sqlCondition .= " GROUP BY vtiger_crmentity.crmid ";
        $idColumn = $main_module->table_name.".".$main_module->table_index;
        $sqlQuery = "SELECT vtiger_crmentity.crmid /* Insert Fields */ ".$sqlTables." /* Insert Tables */ WHERE ".(strlen($sqlCondition) > 3?$sqlCondition:"").'';

        if(!empty($sortField) && $sortField != -1) {
            if(is_array($sortField) && !empty($sortField[0])) {
                $sortDuration = $sortField[1];
                $sortField = $sortField[0];
            } else {
                $sortDuration = '';
            }


            $sortField = VtUtils::getFieldInfo($sortField, getTabId($this->_TargetModule));
            if(!empty($sortField['tablename']) && !empty($sortField['columnname'])) {
                $sqlQuery .= ' ORDER BY ' . $sortField['tablename'] . '.' . $sortField['columnname'] . ' ' . $sortDuration;
            }

        }
        if(!empty($limit) && $limit != -1) {
            $sqlQuery .= " LIMIT ".$limit;
        }

        return $sqlQuery;
    }

    public function beforeGetTaskform($data) {
        //$presetManager = new PresetManager($this->)
    }

    /**
     * @var null|ComplexeCondition
     */
    private $_ConditionObj = null;

    /**
     * @return null|ComplexeCondition
     */
    public function getConditionObj() {
        if($this->_ConditionObj === null) {
            $this->_ConditionObj = new ComplexeCondition('recordsourcecondition', array(
                'toModule' => $this->_TargetModule,
                'fromModule' =>  $this->_TargetModule,
                'disableTemplateFields' => true,
                'mode' => 'mysql',
            ));

            $this->_ConditionObj->setCondition($this->_Data['recordsourcecondition']);
        }

        return $this->_ConditionObj;
    }

    public function getConfigHTML($data, $parameter) {
        $ConditionObj = $this->getConditionObj();
        return $ConditionObj->getHTMLContent();

    }
    public function getConfigInlineJS() {
        $obj = $this->getConditionObj();
        return $obj->getJavaScript();

    }
    public function getConfigInlineCSS() {
        return '.asd { color:red; }';
    }

    public function filterBeforeSave($data) {
        $condObj = $this->getConditionObj();
        $data['recordsourcecondition'] = $condObj->getCondition($data['recordsourcecondition']);

        return $data;
    }
}

\EmailCampaigns\RecordSource::register('condition', '\EmailCampaigns\Plugins\RecordSource\Condition');
