<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
global $root_directory;
require_once($root_directory."/modules/SubscribersList/autoload_wf.php");

class SubscribersList_SaveAjax_Action extends Vtiger_SaveAjax_Action {

	function __construct() {
		parent::__construct();
		$this->exposeMethod('checkDuplicateemail');
		$this->exposeMethod('checkverfyemail');
		$this->exposeMethod('sendenow');
		$this->exposeMethod('schedulelater');
		$this->exposeMethod('schedulelatersave');
		$this->exposeMethod('sendetest');
		$this->exposeMethod('filter_subscribers');

	}

	public function filter_subscribers(Vtiger_Request $request) {
		global $vtiger_current_version;

		if($vtiger_current_version <= "6.5.0"){
			$this->filter_subscribers6($request);
		}else{
			$this->filter_subscribers7($request);
		}

	}

	public function filter_subscribers7(Vtiger_Request $request) {
		global $adb;
		$conditions = $request->get('settings');
		$response = new Vtiger_Response();
        $t = $_POST;
		$module=$request->get('data');
		$module=$module['module'];
		$data = $conditions['condition'];
		if (!empty($data['condition'])) {
			$preset = new \SubscribersList\ComplexeCondition('condition', null, array());
			$condition = $preset->getCondition($data['condition']);

			//$text = $preset->getHTML($condition, $module);
		} else {
			$condition = '';
			//$text = '';
		}
		//$json = base64_encode(json_encode($condition));
        $cleanRecordModel = \SubscribersList\VTEntity::getForId('',$module);
		$obj = new \SubscribersList\ConditionMysql($module, $cleanRecordModel);
		$query = $obj->parse($condition);
		$tables = $obj->generateTables();
		$initialSql = 'SELECT * ' . $tables . ' '; // generic to numeric and count
		$isWhere = ' AND ';
		if (trim($query) != '') {
            $initialSql = $initialSql . ' WHERE deleted=0 AND ' . $query;
        } else {
            $initialSql = $initialSql .' WHERE deleted=0 ';
        }
		$relResult = $adb->query($initialSql);
		$idlist  = array();
		//for ($i = 0; $i < $count; $i++) {
		while ($row = $adb->fetchByAssoc($relResult)) {
// Allora inseriscilo
			$idlist[$row["crmid"]] = $row["crmid"];
	
		}

		$response->setResult(array('count' =>count($idlist)));
		$response->emit();

	}

	public function filter_subscribers6(Vtiger_Request $request) {
		$conditions = $request->get('filter');
		$module = $request->get('module');
		$module_name = $request->get('module_name');
		$response = new Vtiger_Response();
		$wfCondition = array();
			if(!empty($conditions)) {
				foreach($conditions as $index => $condition) {
					$columns = $condition['columns'];
					// if($index == '1' && empty($columns)) {
						// $wfCondition[] = array('fieldname'=>'', 'operation'=>'', 'value'=>'', 'valuetype'=>'',
							// 'joincondition'=>'', 'groupid'=>'0');
					// }
					if(!empty($columns) && is_array($columns) && $index == '1') {
						foreach($columns as $column) {
							$wfCondition[] = array('fieldname'=>$column['columnname'], 'operation'=>$column['comparator'],
								'value'=>$column['value'], 'valuetype'=>$column['valuetype'], 'joincondition'=>$column['column_condition'],
								'groupjoin'=>$condition['condition'], 'groupid'=>'0');
						}
					}else if(!empty($columns) && is_array($columns) && $index == '2'){
						foreach($columns as $column) {
								$wfCondition[] = array('fieldname'=>$column['columnname'], 'operation'=>$column['comparator'],
									'value'=>$column['value'], 'valuetype'=>$column['valuetype'], 'joincondition'=>$column['column_condition'],
									'groupjoin'=>$condition['condition'], 'groupid'=>'1');
							}
					}
				}
			}

		//$expr == $wfCondition;
		$listquery = getListQuery($module_name);
		$listviewquery = substr($listquery, strpos($listquery, 'FROM'), strlen($listquery));
		if($module_name == 'Contacts'){
			$query = "select vtiger_contactdetails.*,vtiger_crmentity.crmid " . $listviewquery . " AND coalesce(vtiger_contactdetails.emailcampaign_optout,0)=0";
		}else if($module_name == 'Leads'){
					$query = "select vtiger_leaddetails.*,vtiger_crmentity.crmid " . $listviewquery . " AND coalesce(vtiger_leaddetails.emailcampaign_optout,0)=0";
		}else if($module_name == 'Accounts'){
					$query = "select vtiger_account.*,vtiger_crmentity.crmid " . $listviewquery . " AND coalesce(vtiger_account.emailcampaign_optout,0)=0";
		}
		require_once 'include/utils/CommonUtils.php';
		require_once 'include/utils/VTCacheUtils.php';

		$skip_uitypes = array('4');
		$cachedModuleFields = VTCacheUtils::lookupFieldInfo_Module($module_name);
		$colf = Array();
		if ($cachedModuleFields) {
			foreach ($cachedModuleFields as $fieldinfo) {
				// Skip non-supported fields
				if (in_array($fieldinfo['uitype'], $skip_uitypes)) {
					continue;
				} else {
					$colf[$fieldinfo['fieldname']] = $fieldinfo['uitype'];
				}
			}
		}

		if (is_array($wfCondition)) {

			$groupResults = array();
			$expressionResults = array();
			$i = 0;
			$sqllist_1f = '';
			$sqllist_2f = '';
			foreach ($wfCondition as $cond) {

				$conditionGroup = $cond['groupid'];
				if (empty($conditionGroup))
					$conditionGroup = 0;
				preg_match('/(\w+) : \((\w+)\) (\w+)/', $cond['fieldname'], $matches);
					$columnslist = $cond['fieldname'];
					//echo "</br>".$columnslist."</br>";
					if (isset($columnslist)) {
						$tablefield = "";
							if ($columnslist != "") {
									$list = explode(":", $columnslist);
									if($colf[$list[2]] == '51' && $module_name == 'Contacts'){
										$sqllist_column = "vtiger_account.accountname";
									}else{
										//Added For getting status for Activities -Jaguar
										$sqllist_column = $list[0] . "." . $list[1];
									}
									//Added for assigned to sorting
									if ($list[1] == "smownerid") {
										$userNameSql = getSqlForNameInDisplayFormat(array('first_name' =>
											'vtiger_users.first_name', 'last_name' => 'vtiger_users.last_name'), 'Users');
										$sqllist_column = "case when (vtiger_users.user_name not like '') then trim($userNameSql) else vtiger_groups.groupname end";
									}
									if ($list[0] == "vtiger_contactdetails" && $list[1] == "lastname"){
										$sqllist_column = "vtiger_contactdetails.lastname";
									}
									$sqllist = '';
									$comparator = $cond['operation'];
									$value = $cond['value'];
									$advfiltersql = EmailCampaigns_SaveAjax_Action::getAdvComparator($comparator, trim($value), $list[4], $sqllist_column);

								}
						if($conditionGroup == 0){
							$sqllist_1 = $sqllist ."".$advfiltersql." ".$cond['joincondition']." ";
						}else if($conditionGroup == 1){
							$sqllist_2 = $sqllist ."".$advfiltersql." ".$cond['joincondition']." ";
						}

						//$returnsql = implode(",", $sqllist);
						if (isset($sqllist_1) && $sqllist_1 != '' && $conditionGroup == 0) {
							$sqllist_1f .=  $sqllist_1;
						}

						if (isset($sqllist_2) && $sqllist_2 != '' && $conditionGroup == 1) {
							$sqllist_2f .=  $sqllist_2;
						}

					}
			}
			if (isset($sqllist_1) && $sqllist_1 != ''){
				$query .= " and (".$sqllist_1f.") ";
			}
			if (isset($sqllist_2) && $sqllist_2 != ''){
				$query .= " and (".$sqllist_2f.")";
			}
		}

		$db = PearDatabase::getInstance();
		$result = $db->pquery($query, array());
		$count = $db->num_rows($result);


		$response->setResult(array('count' =>$count));
		$response->emit();

	}


	public function sendetest(Vtiger_Request $request) {
	global $current_user;
		$ownerid = $current_user->id;
		$recordId = $request->get('record');
		$moduleName = $request->getModule();

		if(!$this->record){
			$this->record = Vtiger_DetailView_Model::getInstance($moduleName, $recordId);
		}
		$recordModel = $this->record->getRecord();
		$module_name = $recordModel->get('module_name');

		$mailer = Emails_Mailer_Model::getInstance();
		$mailer->IsHTML(true);
		$fromEmail = $recordModel->get('from_email');
		$replyTo = $recordModel->get('from_email');
		$userName = $recordModel->get('from_name');
		$toEmailInfo = $recordModel->get('from_email');
		$mailer->reinitialize();
		$mailer->ConfigSenderInfo($fromEmail, $userName, $replyTo);
		$mergedDescription = $recordModel->get('description');

		$description = getMergedDescription($mergedDescription, $id, "Users");
		$mailer->Body = decode_html($description);
		$mailer->Subject = $recordModel->get('subject');
		$mailer->AddAddress($toEmailInfo);
		$status = $mailer->Send(true);
		if(!$status) {
				//$status = $mailer->getError();
			}

		$response = new Vtiger_Response();
		$response->setResult(array('success' => true));
		$response->emit();
	}

	public function process(Vtiger_Request $request) {
		$mode = $request->get('mode');
		if(!empty($mode)) {
			$this->invokeExposedMethod($mode, $request);
			return;
		}
	}




	public function checkDuplicateemail(Vtiger_Request $request) {
		$email = $request->get('email');

		$db = PearDatabase::getInstance();
		$response = new Vtiger_Response();
		$query = "SELECT * FROM from_email_mapping  WHERE email =?";
		$result = $db->pquery($query, array($email));
		if ($db->num_rows($result)) {
			$verify = $db->query_result($result, 0, 'verify');
			$response->setResult(array('success' => true,'verify' =>$verify));
		}else{
			$response->setResult(array('success' => false));
		}

		$response->emit();
	}



	public function send_email($to,$subject,$contents)
	{
		require_once("modules/Emails/class.phpmailer.php");
		require_once("modules/Emails/mail.php");
		global $adb;
		 global $log;

		global $root_directory;

		$adminuser=$adb->pquery("select email1 from vtiger_users where id='1'", array());
		$adminuser_id = $adb->query_result($adminuser,0,'email1');
		$from = $adminuser_id;
		$mail = new PHPMailer();


		$mail->Subject = $subject;
		$mail->Body    = nl2br($contents);//"This is the HTML message body <b>in bold!</b>";


		$mail->IsSMTP();                                      // set mailer to use SMTP

			$mailserverresult=$adb->pquery("select * from vtiger_systems where server_type='email'", array());
			$mail_server = $adb->query_result($mailserverresult,0,'server');
			$mail_server_username = $adb->query_result($mailserverresult,0,'server_username');
			$mail_server_password = $adb->query_result($mailserverresult,0,'server_password');
			$smtp_auth = $adb->query_result($mailserverresult,0,'smtp_auth');

			$_REQUEST['server']=$mail_server;

		$mail->Host = $mail_server;			// specify main and backup server
		if($smtp_auth == 'true')
			$mail->SMTPAuth = true;
		else
			$mail->SMTPAuth = false;
		$mail->Username = $mail_server_username ;	// SMTP username
		$mail->Password = $mail_server_password ;	// SMTP password
		$mail->From = $from;
		$mail->FromName = $initialfrom;
		$mail->AddAddress($to);                  // name is optional
		$mail->WordWrap = 50;                                 // set word wrap to 50 characters

		$mail->IsHTML(true);                                  // set email format to HTML

		$mail->AltBody = "This is the body in plain text for non-HTML mail clients";

		return $flag = MailSend($mail);
	}



}
