<?php
/************************************************************************************************
** The contents of this file are subject to the Vtiger EchoSign Module License Version 1.0
 * ( "License" ); You may not use this file except in compliance with the License
 * The Original Code is:  Technokrafts Labs Pvt Ltd
 * The Initial Developer of the Original Code is Technokrafts Labs Pvt Ltd.
 * Portions created by Technokrafts Labs Pvt Ltd are Copyright ( C ) Technokrafts Labs Pvt Ltd.
 * All Rights Reserved.
**
************************************************************************************************/
 
class Settings_WebVisits_Edit_View extends Settings_Vtiger_Index_View {

	/*TKS*/
	/**
	 * Function to get Header JS
	 */
	public function getHeaderScripts(Vtiger_Request $request) {
		global $log;
		$log->debug("Entering getHeaderScripts(request array()) method....");

		$headerScriptInstances = parent::getHeaderScripts($request);
		$jsFileNames = array(
			"modules.Settings.WebVisits.resources.Edit",
		);

		$jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
		$headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
		$log->debug("Exiting getHeaderScripts(request array()) method....");
		return $headerScriptInstances;
	}
	/*TKS*/
	/**
	 * Function to process editview page
	 */
	public function process(Vtiger_Request $request) 
	{
		global $log;
		$log->debug("Entering process(array() request ) method....");
		global $adb;
		$viewer = $this->getViewer ($request);
		$moduleName = $request->getModule();
		$qualifiedModuleName = $request->getModule(false);
		$record = $request->get('record');
		
		$res = array();
		$res = $this->getCredentials();
		
		
	    if($res[0] == ''){
			 $error = "Please Configure The Module Settings";
			 $viewer->assign('Error', $error);
		}
	
		$viewer->assign('QUALIFIED_MODULE','WebVisits');
		$viewer->assign('settingid', $res['id']);
		$viewer->assign('web_clickacc_number', $res['web_clickacc_number']);
		$viewer->assign('minimum_score', $res['minimum_score']);	
		$viewer->assign('status_new_lead', $res['status_new_lead']);
		$viewer->assign('reactivate_lead', $res['reactivate_lead']);
		$viewer->assign('assumed_close_status', $res['assumed_close_status']);
		$viewer->assign('status_reactive_lead', $res['status_reactive_lead']);
		$viewer->assign('piwik_enabled', $res['piwik_enabled']);
		$viewer->assign('piwik_location', $res['piwik_location']);
		$viewer->assign('piwik_sites', $res['piwik_sites']);
		$viewer->assign('salesfeed_enabled', $res['salesfeed_enabled']);
		$viewer->assign('salesfeed_accnum', $res['salesfeed_accnum']);
		$viewer->assign('snoobi_enabled', $res['snoobi_enabled']);
		$viewer->assign('snoobi_accnum', $res['snoobi_accnum']);
		$viewer->view('Edit.tpl',$qualifiedModuleName);
		$log->debug("Exiting process(array() request ) method....");
	}
	
	/**
	 * Function to get saved credentials
	 */
	public function getCredentials() 
	{
		global $log;
		$log->debug("Entering getCredentials() method....");
		global $adb;
		$res = array();
		$sql       =  'SELECT * FROM vtiger_webvisits_settings ORDER BY id DESC LIMIT 1';
		$result   	= $adb->query($sql);
		if($adb->num_rows($result) > 0)
		{
		
			$res['web_clickacc_number']			= $adb->query_result($result,0,'webclick_tracker_accnum');
			$res['minimum_score']	   	  	 	= $adb->query_result($result,0,'minimum_lead_score');
			$res['status_new_lead']				= $adb->query_result($result,0,'status_for_new_lead');
			$res['reactivate_lead']	       = $adb->query_result($result,0,'reactivate_lead_new_visit');
			$res['assumed_close_status']	   = $adb->query_result($result,0,'assumed_closed_status');
			$res['status_reactive_lead']	   = $adb->query_result($result,0,'status_for_reactivated_lead');
			$res['piwik_enabled']	       = $adb->query_result($result,0,'piwik_enabled');
			$res['salesfeed_enabled']	   = $adb->query_result($result,0,'salesfeed_enabled');
			$res['snoobi_enabled']	       = $adb->query_result($result,0,'snoobi_enabled');
			$res['piwik_location']		=	$adb->query_result($result,0,'piwik_location');
			$res['piwik_sites']	       	=	$adb->query_result($result,0,'piwik_sites');
			$res['salesfeed_accnum']	=	$adb->query_result($result,0,'salesfeed_accnum');
			$res['snoobi_accnum']	    =	$adb->query_result($result,0,'snoobi_accnum');
			$res['id']					=	$adb->query_result($result,0,'id');
		
		}
		
		$log->debug("Exiting getCredentials(array() request ) method....");
		return $res;
	}
}