<?php

/************************************************************************************************
** The contents of this file are subject to the Vtiger EchoSign Module License Version 1.0
 * ( "License" ); You may not use this file except in compliance with the License
 * The Original Code is:  Technokrafts Labs Pvt Ltd
 * The Initial Developer of the Original Code is Technokrafts Labs Pvt Ltd.
 * Portions created by Technokrafts Labs Pvt Ltd are Copyright ( C ) Technokrafts Labs Pvt Ltd.
 * All Rights Reserved.
**
************************************************************************************************/
 
class Settings_WebVisits_SaveWebVisit_Action extends Settings_Vtiger_Index_Action {

	/**
	 * Class Constructor
	 */
	function __construct() {
		global $log;
		$log->debug("Entering __construct() method....");
		parent::__construct();	
		$this->exposeMethod('tks_mode');
	}

	/**
	 * Function to process and invoke requested mode
	 */
	public function process(Vtiger_Request $request) {
		global $log;
		$log->debug("Entering process(request array()) method....");
		 $mode = $request->get('mode');
		if(!empty($mode)) {
			$this->invokeExposedMethod($mode, $request);
		$log->debug("Exiting process(request array()) method....");	
			return;
		}
	}
	
	/**
	 * Function to process and save Echosign Settings
	 */
	 
	public function tks_mode(Vtiger_Request $request)
	{
		global $log,$adb;
		$log->debug("Entering tks_mode(request array()) method....");
		$module = $request->getModule();
		
		$web_clickacc_number 	= trim($request->get('wcnum'));
		$minimum_score 			= trim($request->get('min_score'));
		$status_new_lead		= trim($request->get('status_new_lead'));
		$reactivate_lead		= $request->get('reactivate_lead');
		$assumed_close_status	= trim($request->get('ass_close_sta'));
		$status_reactive_lead	= trim($request->get('status_react_lead'));
		$piwik_enabled			= $request->get('piwik_enabled');
		$piwik_location			= trim($request->get('piwik_location'));
		$piwik_sites			= trim($request->get('piwik_sites'));
		$salesfeed_enabled		= $request->get('salesfeed_enabled');
		$salesfeed_accnum		= trim($request->get('salesfeed_accnum'));
		$snoobi_enabled			= $request->get('snoobi_enabled');
		$snoobi_accnum			= trim($request->get('snoobi_accnum'));
		$id					 	= $request->get('id');
		$apiid					= '';
		
		$query = "DELETE FROM vtiger_webvisits_settings";
		$result = $adb->pquery($query,array());
		
			$this->insertWebVisitsSettings($web_clickacc_number,$minimum_score,$status_new_lead,$reactivate_lead,$assumed_close_status,$status_reactive_lead,$piwik_enabled,$piwik_location,$piwik_sites,$salesfeed_enabled,$salesfeed_accnum,$snoobi_enabled,$snoobi_accnum);
			$res = true;
			$msg = vtranslate('Settings Saved', $module);
		
		$log->debug("Exiting tks_mode(request array()) method....");	
		$this->response($res,$msg,$apiid);
		
	}
	
	/**
	 * Function to forward response if validation fails or success
	 */ 
	private function response($result,$msg,$apiid) 
	{
		global $log;
		$log->debug("Entering response($result,$msg,apiid) method....");

		$response = new Vtiger_Response();
		try
		{
			$log->debug("response($result,$msg,apiid) method.... SETTING NOTIFY");
			$response->setResult( array( 'success'=>true, 'saved' => 'success', 'msg' => $msg, 'appid' => $apiid));
		}
		catch( Exception $e) 
		{
			$log->debug("response($result,$msg,apiid) method.... SETTING ERROR");
			$response->setError( $e->getCode(), $e->getMessage());
		}
		$log->debug("Exiting response($result,$msg,apiid) method....");
		$response->emit();
		exit();
	}
	
	/**
	 * Function to forward response if validation fails or success
	 */ 
	private function checkModuleActive( $module) 
	{
		global $log;
		$log->debug("Entering checkModuleActive($module ) method....");
		$log->debug("Exiting checkModuleActive($module ) method....");
		return vtlib_isModuleActive($module);
	}
	
	/**
	 * Function to forward response if validation fails or success
	 */ 
	private function insertWebVisitsSettings($web_clickacc_number,$minimum_score,$status_new_lead,$reactivate_lead,$assumed_close_status,$status_reactive_lead,$piwik_enabled,$piwik_location,$piwik_sites,$salesfeed_enabled,$salesfeed_accnum,$snoobi_enabled,$snoobi_accnum) 
	{
	
		global $log;
		$log->debug("Entering response($api) method....");
		global $adb;
		
		$sql       = "insert into vtiger_webvisits_settings(`webclick_tracker_accnum`, `minimum_lead_score`, `status_for_new_lead`,`reactivate_lead_new_visit`,`assumed_closed_status`,`status_for_reactivated_lead`,`piwik_enabled`,`piwik_location`,`piwik_sites`,`salesfeed_enabled`,`salesfeed_accnum`,`snoobi_enabled`,`snoobi_accnum`) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
		$params    = array($web_clickacc_number, $minimum_score, $status_new_lead,$reactivate_lead,$assumed_close_status,$status_reactive_lead,$piwik_enabled,$piwik_location,$piwik_sites,$salesfeed_enabled,$salesfeed_accnum,$snoobi_enabled,$snoobi_accnum);
		$result    = $adb->pquery($sql, $params);
	}
}