<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

class Settings_VebWebforms_LeadsEdit_View extends Settings_Vtiger_Index_View {

  public function requiresPermission(\Vtiger_Request $request) {

    $permissions = parent::requiresPermission($request);
    $permissions[] = array('module_parameter' => 'module', 'action' => 'DetailView');

    return $permissions;
  }
  
  public function process(Vtiger_Request $request) {

// var_dump(Settings_VebWebforms_Module_Model::getInstance('VebWebforms'));
// var_dump(Settings_VebWebforms_Module_Model::getInstance('Leads'));

    $qualifiedModuleName = $request->getModule(false);
    $viewer = $this->getViewer($request);
    
    $viewer->assign('MODULE_MODEL', Settings_VebWebforms_Leads_Model::getInstance());
    $viewer->assign('POTENTIALS_MODULE_MODEL', Settings_VebWebforms_Module_Model::getInstance('VebWebforms'));
    $viewer->assign('PROJECT_MODULE_MODEL', Settings_VebWebforms_Module_Model::getInstance('Leads'));

    $viewer->assign('QUALIFIED_MODULE', $qualifiedModuleName);
    $viewer->assign('RESTRICTED_FIELD_IDS_LIST', Settings_VebWebforms_Leads_Model::getRestrictedFieldIdsList());
    $viewer->view('Edit.tpl', $qualifiedModuleName);
  }
  
  /**
   * Function to get the list of Script models to be included
   * @param Vtiger_Request $request
   * @return <Array> - List of Vtiger_JsScript_Model instances
   */
  function obsolete_getHeaderScripts(Vtiger_Request $request) {

    $headerScriptInstances = parent::getHeaderScripts($request);
    $moduleName = $request->getModule();

    $jsFileNames = array(
      "modules.Settings.$moduleName.resources.VebWebforms"
    );

    $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
    $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);

    return $headerScriptInstances;
  }
}
