<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Settings_VebWebforms_Accounts_Model extends Settings_Leads_Mapping_Model {
  
  var $name = 'VebWebforms';
  var $moduleName = 'VebWebforms';

  /**
   * Function to get headers for detail view
   * @return <Array> headers list
   */
  public function getHeaders() {

    return array('VebWebforms' => 'VebWebforms', 'Type' => 'Type', 'Accounts' => 'Accounts');
  }

  /**
   * Function to get detail view url of this model
   * @return <String> url
   */
  public function getDetailViewUrl() {

    return 'index.php?parent='. $this->getParentName() .'&module=VebWebforms&view=AccountsDetail';
  }

  /**
   * Function to get edit view url of this model
   * @return <String> url
   */
  public function getEditViewUrl() {

    return 'index.php?parent='. $this->getParentName() .'&module=VebWebforms&view=AccountsEdit';
  }

  /**
   * Function to get list of detail view link models
   * @return <Array> list of detail view link models <Vtiger_Link_Model>
   */
  public function getDetailViewLinks() {

    return array(Vtiger_Link_Model::getInstanceFromValues(array(
        'linktype' => 'DETAILVIEW',
        'linklabel' => 'LBL_EDIT',
        'linkurl' => 'javascript:Settings_VebWebforms_Js.triggerEdit("'. $this->getEditViewUrl() .'")',
        'linkicon' => ''
        )));
  }

  /**
   * Function to get delete url of this mapping model
   * @return <String> url
   */
  public function getMappingDeleteUrl() {

    return 'index.php?parent='. $this->getParentName() .'&module=VebWebforms&action=Delete';
  }

  /**
   * Function to get list of mapping link models
   * @return <Array> list of mapping link models <Vtiger_Link_Model>
   */
  public function getMappingLinks() {

    return array(Vtiger_Link_Model::getInstanceFromValues(array(
        'linktype' => 'DETAILVIEW',
        'linklabel' => 'LBL_DELETE',
        'linkurl' => 'javascript:Settings_VebWebforms_Js.triggerDelete(event,"'. $this->getMappingDeleteUrl() .'")',
        'linkicon' => ''
        )));
  }

  /**
   * Function to get mapping details
   * @return <Array> list of mapping details
   */
  public function getMapping($editable = false) {

    if (!$this->mapping) {

      $db = PearDatabase::getInstance();
      $query = 'SELECT * FROM vtiger_vebwebformaccountmapping';

      if ($editable) {

        $query .= ' WHERE editable = 1';
      }

      $result = $db->pquery($query, array());
      $numOfRows = $db->num_rows($result);
      $mapping = array();

      for ($i=0; $i<$numOfRows; $i++) {

        $rowData = $db->query_result_rowdata($result, $i);
        $mapping[$rowData['cfmid']] = $rowData;
      }

      $finalMapping = $fieldIdsList = array();

      foreach ($mapping as $mappingDetails) {

        array_push($fieldIdsList, $mappingDetails['vebwebformfid'], $mappingDetails['projectfid']);
      }

      $fieldLabelsList = array();

      if(!empty($fieldIdsList)){

        $fieldLabelsList = $this->getFieldsInfo(array_unique($fieldIdsList));
      }

      foreach ($mapping as $mappingId => $mappingDetails) {

      $finalMapping[$mappingId] = array(
            'editable'  => $mappingDetails['editable'],
            'VebWebforms'  => $fieldLabelsList[$mappingDetails['vebwebformfid']],
            'Project'  => $fieldLabelsList[$mappingDetails['projectfid']]
        );
      }

      $this->mapping = $finalMapping;
    }

    return $this->mapping;
  }

  /**
   * Function to save the mapping info
   * @param <Array> $mapping info
   */
  public function save($mapping) {

    $db = PearDatabase::getInstance();
    $deleteMappingsList = $updateMappingsList = $createMappingsList = array();

    foreach ($mapping as $mappingDetails) {

      $mappingId = $mappingDetails['mappingId'];

      if ($mappingDetails['potential']) {

        if ($mappingId) {

          if ((array_key_exists('deletable', $mappingDetails)) || (!$mappingDetails['project'])) {

            $deleteMappingsList[] = $mappingId;

          }
                    else {
            if ($mappingDetails['project']) {
              $updateMappingsList[] = $mappingDetails;
            }
          }

        }
                else {
          if ($mappingDetails['project']) {
            $createMappingsList[] = $mappingDetails;
          }
        }
      }
    }

    if ($deleteMappingsList) {
      $db->pquery('DELETE FROM vtiger_vebwebformaccountmapping
          WHERE editable = 1
          AND cfmid IN ('. generateQuestionMarks($deleteMappingsList) .')', $deleteMappingsList);
    }

    if ($createMappingsList) {
      $insertQuery = 'INSERT INTO vtiger_vebwebformaccountmapping(vebwebformfid, projectfid) VALUES ';

      $count = count($createMappingsList);
          $params = array();
      for ($i=0; $i<$count; $i++) {
        $mappingDetails = $createMappingsList[$i];
        $insertQuery .= '(?, ?)';
            array_push($params, $mappingDetails['potential'], $mappingDetails['project']);
        if ($i !== $count-1) {
          $insertQuery .= ', ';
        }
      }
      $db->pquery($insertQuery, $params);
    }

    if ($updateMappingsList) {
      $potentialQuery    = ' SET vebwebformfid = CASE ';
      $projectQuery  = ' projectfid = CASE ';

      foreach ($updateMappingsList as $mappingDetails) {
        $mappingId   = $mappingDetails['mappingId'];
        $potentialQuery  .= " WHEN cfmid = $mappingId THEN ". $mappingDetails['potential'];
        $projectQuery  .= " WHEN cfmid = $mappingId THEN ". $mappingDetails['project'];
      }
      $potentialQuery    .= ' ELSE vebwebformfid END ';
      $projectQuery  .= ' ELSE projectfid END ';

      $db->pquery("UPDATE vtiger_vebwebformaccountmapping $potentialQuery, $projectQuery WHERE editable = ?", array(1));
    }
  }

  /**
   * Function to get restricted field ids list
   * @return <Array> list of field ids
   */
  public static function getRestrictedFieldIdsList() {
    $db = PearDatabase::getInstance();
    $result = $db->pquery('SELECT * FROM vtiger_vebwebformaccountmapping WHERE editable = ?', array(0));
    $numOfRows = $db->num_rows($result);

    $restrictedIdsList = array();
    for ($i=0; $i<$numOfRows; $i++) {
      $rowData = $db->query_result_rowdata($result, $i);
      if ($rowData['projectfid']) {
        $restrictedIdsList[] = $rowData['projectfid'];
      }
    }
    return $restrictedIdsList;
  }

    /**
     * Function to get mapping supported modules list
     * @return <Array>
     */
    public static function getDestinationEntity() {

        return 'Accounts';
    }

  /**
   * Function to get mapping supported modules list
   * @return <Array>
   */
  public static function getSupportedModulesList() {
    return array('Accounts');
  }

  /**
   * Function to delate the mapping
   * @param <Array> $mappingIdsList
   */
  public static function deleteMapping($mappingIdsList) {

    $db = PearDatabase::getInstance();
    $db->pquery('DELETE FROM vtiger_vebwebformaccountmapping WHERE cfmid IN ('. generateQuestionMarks($mappingIdsList). ')', $mappingIdsList);
  }
  
  /**
   * Function to get instance
   * @param <Boolean> true/false
   * @return <Settings_Potentials_Mapping_Model>
   */
  public static function getInstance($editable = false) {

    $instance = new self();
    $instance->getMapping($editable);
    return $instance;
  }

  /**
   * Function to get instance
   * @return <Settings_Potentials_Mapping_Model>
   */
  public static function getCleanInstance() {

    return new self();
  }
}
