<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

// ini_set('display_errors','on'); error_reporting(E_ALL); // STRICT DEVELOPMENT

class Settings_VebSettings_Edit_View extends Settings_Vtiger_Index_View {

  public function process(Vtiger_Request $request) {

    $qualifiedModuleName = 'Settings:VebSettings';

    $settingsRecordModel = Settings_VebSettings_Record_Model::getInstance($request->get('id'));
    $settingsModuleModel = Settings_VebSettings_Module_Model::getInstance($settingsRecordModel);

    $viewer = $this->getViewer($request);

    $viewer->assign('RECORD_MODEL', $settingsRecordModel);
    $viewer->assign('MODULE_MODEL', $settingsModuleModel);
    $viewer->assign('CURRENT_USER_MODEL', Users_Record_Model::getCurrentUserModel());
    $viewer->assign('QUALIFIED_MODULE', $qualifiedModuleName);

    $viewer->view('Edit.tpl',$qualifiedModuleName);
  }

  /**
   * Function to get the list of Script models to be included
   * @param Vtiger_Request $request
   * @return <Array> - List of Vtiger_JsScript_Model instances
   */
  function getHeaderScripts(Vtiger_Request $request) {

    $headerScriptInstances = parent::getHeaderScripts($request);
    $moduleName = $request->getModule();

    $jsFileNames = array(

      "modules.Settings.$moduleName.resources.VebSettings"
    );

    $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
    $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
    return $headerScriptInstances;
  }
    
  /**
   * Setting module related Information to $viewer (for Vtiger7)
   * @param type $request
   * @param type $moduleModel
   */
  public function old_setModuleInfo($request, $moduleModel){

    $record = $request->get('record');

    if ($record) {

      $viewer = $this->getViewer($request);
      $listViewModel = Settings_Vtiger_ListView_Model::getInstance($request->getModule(false));
      $linkParams = array('MODULE'=>$request->getModule(false), 'ACTION'=>$request->get('view'));

      if(!$this->listViewLinks) {

        $this->listViewLinks = $listViewModel->getListViewLinks($linkParams);
      }
      $viewer->assign('LISTVIEW_LINKS', $this->listViewLinks);
    }
  }
}
