<?php
// ini_set('display_errors','on'); error_reporting(E_ALL); // STRICT DEVELOPMENT
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

/**
 * Roles Record Model Class
 */
class Settings_VebSettings_Record_Model extends Settings_Vtiger_Record_Model {

  protected static $settings = false;

  const tableName = 'vtiger_veb_settings';

  const optionSeparator = '$';

  /**
   * Function to get the Id
   * @return <Number> Group Id
   */
  public function getId() {

    return $this->get('id');
  }

  /**
   * Function to set the Id
   * @param <Number> Group Id
   * @return <Settings_Groups_Reord_Model> instance
   */
  public function setId($id) {

    return $this->set('id', $id);
  }

  /**
   * Function to get the Group Name
   * @return <String>
   */
  public function getName() {

    return $this->get('id');
  }

  /**
   * Function to get record links
   * @return <Array> list of link models <Vtiger_Link_Model>
  */
  public function getRecordLinks() {

    $links = array();
    $recordLinks = array(array('linktype' => 'LISTVIEWRECORD',
                               'linklabel' => 'LBL_EDIT',
                               'linkurl' => $this->getEditViewUrl(),
                               'linkicon' => 'fa fa-pencil icon-pencil'
                         )
                   );

    foreach($recordLinks as $recordLink) {

      $links[] = Vtiger_Link_Model::getInstanceFromValues($recordLink);
    }

    return $links;
  }

  /**
   * Function to get the Detail Url for the current group
   * @return <String>
   */
  public function getDetailViewUrl() {

      return 'index.php?module=VebSettings&parent=Settings&view=Detail&id=' . $this->getId();
  }

  /**
   * Function to get the Edit View Url for the Group
   * @return <String>
   */
  public function getEditViewUrl() {

    return 'index.php?module=VebSettings&parent=Settings&view=Edit&id=' . $this->getId();
  } 

  /**
   * Function to save the settings
   */
  public function save() {

    $db = PearDatabase::getInstance();

    $recordId = $this->getId();
    $moduleName = $this->get('module');
    $settingsForModule = $this->get('settingsfor');

    $skipFields = array('__vtrftk', 'action', 'parent', 'module', 'id', 'settingsfor');

    $params = array();

    $objectVars = get_object_vars($this);
    $formVars = $objectVars['valueMap'];

    foreach($skipFields as $skipField) {

      unset($formVars[$skipField]);
    }

    $serializedData = serialize($formVars);

    $query = 'UPDATE ' . self::tableName . ' SET data = ? WHERE id = ? AND module = ?';
    $params = array($serializedData, $recordId, $settingsForModule);

    $db->pquery($query, $params);

    if ($moduleName == 'VebSettings' && $moduleName == $settingsForModule) {

      // extra admin queries
      $query = 'UPDATE ' . self::tableName . ' SET deleted = 1';
      $db->pquery($query, array());

      foreach($formVars['editable'] as $option) {

        list($module, $garbage) = explode(self::optionSeparator, $option);
        $query = 'UPDATE ' . self::tableName . ' SET deleted = 0 WHERE module = ?';
        $db->pquery($query, array($module));
      }
    }

    return $recordId;
  }

  public function getDisplayValue($key) {

    if ($key == 'name') $key = 'module';

    return $this->get($key);
  }

  public static function getInstance($id='Settings:VebSettings') {

    $query = 'SELECT * FROM ' . self::tableName . ' WHERE id = ?';
    $params = array($id);

    return self::getRecordModel($query, $params);
  }

  private static function getRecordModel($query, $params) {

    $componentName = 'VebSettings';

    $db = PearDatabase::getInstance();

    $result = $db->pquery($query, $params);

    try {

      $modelClassName = Vtiger_Loader::getComponentClassName('Model', $componentName, 'Settings:Vtiger');
    }
    catch(Exception $e) {

      $modelClassName = new self;
    }

    $instance = new $modelClassName();

    $instance->configured = false;

    if($db->num_rows($result) > 0) {

      $rowData = $db->query_result_rowdata($result, 0);

      $instance->setData($rowData);

      $instance->configured = true;
    }

    return $instance;
  }

  public static function getOptionValue($option) {

    list($optionValue, $optionText) = explode(self::optionSeparator, $option);

    return $optionValue;
  }

  public static function getOptionText($option) {

    list($optionValue, $optionText) = explode(self::optionSeparator, $option);

    return $optionText;
  }

  public static function getAdminSettings() {

    $db = PearDatabase::getInstance();

    $query = "SELECT module FROM " . self::tableName . " WHERE module != 'VebSettings'";
    $params = array();
    $result = $db->pquery($query, $params);

    $fieldsInfo = array();

    if($db->num_rows($result) > 0) {

      while($rowData = $db->fetch_array($result)) {

        $fieldsInfo[] = array('id' => $rowData['module'],
                              'name' => vtranslate($rowData['module'], $rowData['module']));
      }
    }

    return $fieldsInfo;
  }

  // do not change these underlying functions !!!
  public static function getSetting($param, $moduleName) {

    return self::getSettings($moduleName)->get($param);
  }

  public static function getSettings($moduleName) {

    $query = 'SELECT data FROM ' . self::tableName . ' WHERE module = ?';
    $params = array($moduleName);

    $recordModel = self::getRecordModel($query, $params);

    $fieldValues = unserialize(html_entity_decode($recordModel->get('data'), ENT_QUOTES));

    // get default values
    if ($fieldValues === false) $fieldValues = self::getDefaults($moduleName);

    $recordModel->setData($fieldValues);

    return $recordModel;
  }

  private function getDefaults($moduleName) {

    $query = 'SELECT serialized FROM ' . self::tableName . ' WHERE module = ?';
    $params = array($moduleName);

    $recordModel = self::getRecordModel($query, $params);

    $fieldData = unserialize(html_entity_decode($recordModel->get('serialized'), ENT_QUOTES));

    foreach($fieldData as $index => $data) {

      $fieldData[$data['field']] = $data['default'];
    }

    return $fieldData;
  }

  public static function isConfigured($moduleName) {

    $moduleSettings = self::getSettings($moduleName);
    return ($moduleSettings->configured === true);
  }
}
