<?php
// ini_set('display_errors','on'); error_reporting(E_ALL); // STRICT DEVELOPMENT
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

/*
 * Settings Module Model Class
 */
class Settings_VebSettings_Module_Model extends Settings_Vtiger_Module_Model {

  var $baseTable = 'vtiger_veb_settings';
  var $baseIndex = 'id';
  var $name = 'VebSettings';
  var $listFields = array('name' => 'Module Name', 'language' => 'Taal', 'description' => 'Omschrijving');

  public function hasCreatePermissions() {

    return false;
  }

  /**
   * Function to get the Edit View Url for the Group
   * @return <String>
   */
  public function getEditViewUrl() {

    return 'index.php?module=VebSettings&parent=Settings&view=Edit';
  }

  /**
   * Static Function to get the instance of Vtiger Module Model for the given id or name
  * @param mixed id or name of the module
   */
  public static function getInstance($recordModel) {

    $fieldData = unserialize(html_entity_decode($recordModel->get('serialized'), ENT_QUOTES));
    $fieldValues = unserialize(html_entity_decode($recordModel->get('data'), ENT_QUOTES));

    foreach($fieldData as $index => $data) {

      // if not defined yet, set default
      if ($fieldValues === false && !in_array($data['type'], array('picklist','multiselect'))) {

        $fieldData[$index]['value'] = $data['default'];
        continue;
      }

      // fieldValues for a field can be an array
      $fieldData[$index]['value'] = $fieldValues[$data['field']];

      if ($data['type'] == 'picklist' || $data['type'] == 'multiselect') {

        switch($data['picklist']) {

          case 'templates':

            $fieldData[$index]['data'] = self::getTemplates($data['module']);
            break;

          case 'users':

            $fieldData[$index]['data'] = self::getUsers();
            break;

          case 'groups':

            $fieldData[$index]['data'] = self::getGroups();
            break;

          case 'modules':

            $fieldData[$index]['data'] = self::getModulesList();
            break;

          case 'fields':

            $fieldData[$index]['data'] = self::getModuleFields($data['module']);
            break;

          case 'options':

            $fieldData[$index]['data'] = self::getSelectValues($data['options']);
            break;

          default:

            $fieldData[$index]['data'] = self::getPicklistValues($data);
            break;
        }
      }
    }

    $instance = new self();
    $instance->data = $fieldData;

    return $instance;
  }

  private function getTemplates($moduleName) {

    $tpls = array();

    $templates = EmailTemplates_Record_Model::getAllForEmailTask($moduleName);

    foreach($templates as $template) {

      $tpls[] = array('id' => $template->get('templateid'), 'name' => $template->get('templatename'));
    }
    return $tpls;
  }

  private function getGroups() {

    global $default_charset;
    $systemGroups = get_group_array();
    $groups = array();

    foreach($systemGroups as $groupId => $groupName) {

      if ($groupName == '') continue;

      $groups[] = array('id' => $groupId, 'name' => html_entity_decode($groupName, ENT_QUOTES, $default_charset));
    }

    return $groups;
  }

  private function getUsers() {

    $systemUsers = get_user_array();
    $users = array();

    foreach($systemUsers as $userId => $userName) {

      if ($userName == '') continue;

      $emailAddress = getUserEmail($userId);
      $users[] = array('id' => $userId, 'name' => sprintf("%s - %s", $userName, $emailAddress));
    }

    return $users;
  }

  private static function getModuleFields($moduleName) {

    if ($moduleName === 'VebSettings') {

      // admin routine
      $fieldsInfo = Settings_VebSettings_Record_Model::getAdminSettings();
    }
    else {

      $moduleModel = Vtiger_Module_Model::getInstance($moduleName);
      $moduleFields = $moduleModel->getFields();

      $fieldsInfo = array();

      foreach($moduleFields as $fieldName => $fieldModel){

        $fieldsInfo[] = array('id' => $fieldName,
                              'name' => vtranslate($fieldModel->get('label'), $moduleName));
      }
    }

    return $fieldsInfo;
  }

  private static function getPicklistValues($data) {

    $moduleName = $data['module'];
    $fieldName = $data['picklist'];
    $moduleInstance = Vtiger_Module_Model::getInstance($moduleName);
    $fieldModel = Vtiger_Field_Model::getInstance($fieldName, $moduleInstance);

    foreach($fieldModel->getPicklistValues() as $optionId => $optionValue){

      $fieldsInfo[] = array('id' => $optionId,
                            'name' => vtranslate($optionValue, $moduleName));
    }

    return $fieldsInfo;
  }

  private static function getSelectValues($optionValues) {

    if (!is_array($optionValues)) $optionValues = (array)$optionValues;

    foreach($optionValues as $optionId => $optionValue) {

      $fieldsInfo[] = array('id' => $optionId,
                            'name' => vtranslate($optionValue, $moduleName));
    }

    return $fieldsInfo;
  }

  private static function getModulesList() {

    $allModules = Settings_ModuleManager_Module_Model::getAll();
    $modulesList = array();

    foreach($allModules as $module) {

      $moduleName = $module->getName();

      $fieldsInfo[] = array('id' => $moduleName,
                            'name' => vtranslate($moduleName, $moduleName));
    }

    return $fieldsInfo;
  }

  public function get($propertyName) {

    return $this->$propertyName;
  }
}
