<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

// ini_set('display_errors','on'); error_reporting(E_ALL); // STRICT DEVELOPMENT

class Settings_VebMapping_MappingEdit_View extends Settings_Vtiger_Index_View {

	public function checkPermission(\Vtiger_Request $request) {

		return true;
	}

	public function requiresPermission(\Vtiger_Request $request) {

		$permissions = parent::requiresPermission($request);
		$permissions[] = array('module_parameter' => 'module', 'action' => 'DetailView');

		return $permissions;
	}
    
	public function process(\Vtiger_Request $request) {

		$qualifiedModuleName = $request->getModule(false);
		$viewer = $this->getViewer($request);

		$viewer->assign('MODULE_MODEL', Settings_VebMapping_Mapping_Model::getInstance());

		$viewer->assign('SRC_MODULE_MODEL', Settings_VebMapping_Module_Model::getInstance($request->get('src')));
		$viewer->assign('DST_MODULE_MODEL', Settings_VebMapping_Module_Model::getInstance($request->get('dst')));

		$viewer->assign('QUALIFIED_MODULE', $qualifiedModuleName);
		$viewer->assign('RESTRICTED_FIELD_IDS_LIST', Settings_VebMapping_Mapping_Model::getRestrictedFieldIdsList());

		$viewer->view('MappingEdit.tpl', $qualifiedModuleName);
	}
	
	/**
	 * Function to get the list of Script models to be included
	 * @param Vtiger_Request $request
	 * @return <Array> - List of Vtiger_JsScript_Model instances
	 */
	function getHeaderScripts(Vtiger_Request $request) {

		$headerScriptInstances = parent::getHeaderScripts($request);
		$moduleName = $request->getModule();

		$jsFileNames = array(

			"modules.Settings.$moduleName.resources.VebMapping"
		);

		$jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
		$headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);

		return $headerScriptInstances;
	}
}
