<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

// ini_set('display_errors','on'); error_reporting(E_ALL); // STRICT DEVELOPMENT

class Settings_VebMapping_MappingDetail_View extends Settings_Vtiger_Index_View {

	var $srcEntity;
	var $dstEntity;

	protected function setSrcEntity($moduleName) {

		$this->srcEntity = $moduleName;
	}

	protected function setDstEntity($moduleName) {

		$this->dstEntity = $moduleName;
	}

	public function checkPermission(\Vtiger_Request $request) {

		return true;
	}

	public function requiresPermission(\Vtiger_Request $request) {

		$permissions = parent::requiresPermission($request);
		$permissions[] = array('module_parameter' => 'module', 'action' => 'DetailView');

		return $permissions;
	}
    
	function obsolete_checkPermission(Vtiger_Request $request) {

		return parent::checkPermission($request);
	}

	public function process(Vtiger_Request $request) {

		$qualifiedModuleName = $request->getModule(false);

		$viewer = $this->getViewer($request);
		$viewer->assign('DISPLAY_SEQUENCE', array(1,0));
		$viewer->assign('MODULE_MODEL', Settings_VebMapping_Mapping_Model::getInstance());

		$viewer->assign('SRC_MODULE', Settings_VebMapping_Module_Model::getSrcModuleInstance($this->srcEntity));
		$viewer->assign('DST_MODULE', Settings_VebMapping_Module_Model::getDstModuleInstance($this->dstEntity));

		$viewer->assign('ERROR_MESSAGE', $request->get('errorMessage'));
		$viewer->assign('QUALIFIED_MODULE', $qualifiedModuleName);

		$viewer->view('MappingDetail.tpl', $qualifiedModuleName);
	}

	/**
	 * Function to get the list of Script models to be included
	 * @param Vtiger_Request $request
	 * @return <Array> - List of Vtiger_JsScript_Model instances
	 */
	function getHeaderScripts(Vtiger_Request $request) {

		$headerScriptInstances = parent::getHeaderScripts($request);
		$moduleName = $request->getModule();

		$jsFileNames = array(
			"modules.Settings.$moduleName.resources.VebMapping",
			"~layouts/".Vtiger_Viewer::getDefaultLayoutName()."/lib/jquery/floatThead/jquery.floatThead.js",
			"~layouts/".Vtiger_Viewer::getDefaultLayoutName()."/lib/jquery/perfect-scrollbar/js/perfect-scrollbar.jquery.js",
		);

		$jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
		$headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);

		return $headerScriptInstances;
	}

	public function getHeaderCss(Vtiger_Request $request) {

		$headerCssInstances = parent::getHeaderCss($request);

		$cssFileNames = array(
			"~layouts/".Vtiger_Viewer::getDefaultLayoutName()."/lib/jquery/perfect-scrollbar/css/perfect-scrollbar.css",
		);

		$cssInstances = $this->checkAndConvertCssStyles($cssFileNames);
		$headerCssInstances = array_merge($headerCssInstances, $cssInstances);

		return $headerCssInstances;
	}
}
