<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

// class Settings_VebMapping_Module_Model extends Vtiger_Module_Model {
class Settings_VebMapping_Module_Model extends Settings_Leads_Module_Model {

  /**
   * Function to get fields of this model
   * @return <Array> list of field models <Settings_Leads_Field_Model>
   */
  public function getFields($blockInstance=false) {

    if (!$this->fields) {

      $fieldModelsList = array();
      $fieldIds = $this->getMappingSupportedFieldIdsList();

      foreach ($fieldIds as $fieldId) {

        $fieldModel = Settings_Leads_Field_Model::getInstance($fieldId, $this);
        $fieldModelsList[$fieldModel->getFieldDataType()][$fieldId] = $fieldModel;
      }

      $this->fields = $fieldModelsList;
    }

    return $this->fields;
  }

  /**
   * Function to get mapping supported field ids list
   * @return <Array> list of field ids
   */
  public function getMappingSupportedFieldIdsList() {

    if (!$this->supportedFieldIdsList) {

      $selectedTabidsList[] = getTabid($this->getName());
      $restrictedUitypes = $this->getRestrictedUitypes();
      $selectedGeneratedTypes = array(1, 2);
      $restrictedFieldNames = array('campaignrelstatus');

      $db = PearDatabase::getInstance();
      $query = 'SELECT fldname from vtiger_veb_mapping_excluded WHERE tabid = ?';
      $params = array($selectedTabidsList);
      $result = $db->pquery($query, $params);

      $numOfRows = $db->num_rows($result);
      for ($i=0; $i<$numOfRows; $i++) {

        $restrictedFieldNames[] = $db->query_result($result, $i, 'fldname');
      }

      $query = 'SELECT fieldid FROM vtiger_field
                WHERE tabid IN ('. generateQuestionMarks($selectedTabidsList) .')
                AND uitype NOT IN ('. generateQuestionMarks($restrictedUitypes) .')
                AND fieldname NOT IN ('. generateQuestionMarks($restrictedFieldNames) .')
                AND generatedtype IN ('.generateQuestionMarks($selectedGeneratedTypes).')';

      $params = array_merge($selectedTabidsList, $restrictedUitypes, $restrictedFieldNames, $selectedGeneratedTypes);

      $result = $db->pquery($query, $params);

      $numOfRows = $db->num_rows($result);

      $fieldIdsList = array();

      for ($i=0; $i<$numOfRows; $i++) {

        $fieldIdsList[] = $db->query_result($result, $i, 'fieldid');
      }

      $this->supportedFieldIdsList = $fieldIdsList;
    }

    return $this->supportedFieldIdsList;
  }
    
  /**
   * Function to get the Restricted Ui Types
   * @return <array> Restricted ui types
   */
  public function getRestrictedUitypes() {

    return array(4, 51, 52, 53, 57, 58, 70);
  }

  public static function getSrcModuleInstance($moduleName) {

    return self::getInstance($moduleName);
  }

  public static function getDstModuleInstance($moduleName) {

    return self::getInstance($moduleName);
  }

  /**
   * Function to get instance of module
   * @param <String> $moduleName
   * @return <Settings_Leads_Module_Model>
   */
  public static function getInstance($moduleName) {

    $moduleModel = parent::getInstance($moduleName);
    $objectProperties = get_object_vars($moduleModel);

    $moduleModel = new self();
    foreach  ($objectProperties as $properName => $propertyValue) {
      $moduleModel->$properName = $propertyValue;
    }

    return $moduleModel;
  }

  public static function getMapping($srcTab, $dstTab) {

    $db = PearDatabase::getInstance();

    $srcTabId = getTabId($srcTab);
    $dstTabId = getTabId($dstTab);

    $query = "SELECT * FROM vtiger_veb_mapping
              WHERE srctab = ?
              AND dsttab = ?
              AND editable = 1";

    $params = array($srcTabId, $dstTabId);
    $result = $db->pquery($query, $params);

    $numOfRows = $db->num_rows($result);

    for ($i=0; $i<$numOfRows; $i++) {

      $srcFldId =  $db->query_result($result, $i, 'srcfid');
      $dstFldId =  $db->query_result($result, $i, 'dstfid');

      // of iets als:
      // $fieldModel = Vtiger_Field_Model::getInstance($fieldId, $instance);
      // $leadFieldName = $fieldModel->getName();

      // get the fldname
      $srcFldName = self::getFieldName($srcFldId);
      $dstFldName = self::getFieldName($dstFldId);

      $fldMapping[$srcFldName] = $dstFldName;
    }

    return $fldMapping;
  }

  private function getFieldName($fldId) {

    // static function getSingleFieldValue($tablename, $fieldname, $idname, $id)
    // $fieldval = $adb->query_result($adb->pquery("select $fieldname from $tablename where $idname = ?", array($id)), 0, $fieldname);
    return Vtiger_Functions::getSingleFieldValue('vtiger_field', 'fieldname', 'fieldid', $fldId);
  }
}
