<?php
class Settings_VebMapping_ConvertAdditionalFieldsAjax_Action extends Settings_Vtiger_Index_Action {

    public function process(Vtiger_Request $request) {

      global $current_user;

      $params = $request->get('parameters');
       
      $dstModule = $params['module'];

      // we can have:
      // - potential_id
      // - quote_id
      // - invoice_id
      // - salesorder_id
      if (array_key_exists('quote_id', $params)) {

        $srcModule = 'Quotes';
        $srcRecordId = $params['quote_id'];
      }

      if (array_key_exists('invoice_id', $params)) {

        $srcModule = 'Invoice';
        $srcRecordId = $params['invoice_id'];
      }

      if (array_key_exists('potential_id', $params)) {

        $srcModule = 'Potentials';
        $srcRecordId = $params['potential_id'];
      }

      if (array_key_exists('salesorder_id', $params)) {

        $srcModule = 'SalesOrder';
        $srcRecordId = $params['salesorder_id'];
      }

      // $adb = PearDatabase::getInstance();
      // get the mapping
      $mappingModel = Settings_VebMapping_Mapping_Model::getInstance();

      // get the custom defined fiedls only
      $mapping = $mappingModel->getMapping($srcModule, $dstModule, 1);

      // get the values from db
      $focus = CRMEntity::getInstance($srcModule);
      $focus->id = $srcRecordId;
      $focus->retrieve_entity_info($srcRecordId, $srcModule);

      $recordModel = Vtiger_Record_Model::getCleanInstance($dstModule);

      // $focus->column_fields;
      foreach($mapping as $mappingData) {

        $srcField = $mappingData['srcModule']['id'];
        $dstField = $mappingData['dstModule']['id'];

        $label = null;

        // determine type of to field
        $fieldModel = Settings_VebMapping_Field_Model::getInstance($dstField, $recordModel->getModule());
        $dstFieldName = $fieldModel->getName();
        $dstFieldType = $fieldModel->getFieldDataType();

        // get the source field info
        $fieldInfo = Vtiger_Functions::getModuleFieldInfoWithId($srcField);
        $srcFieldName = $fieldInfo['columnname'];

        /*
           $type = 'reference';
           // query setype uit crmentity - bewaar het label (?)
           $query = "SELECT label FROM vtiger_crmentity WHERE crmid = ? AND deleted = 0";
           $params = array($focus->column_fields[$fromField]);
           $result = $adb->pquery($query, $params);
           $label = $adb->query_result($result, 0, 'label');
           break;
        */
       $value = $focus->column_fields[$srcFieldName];

       if (empty($value)) continue;

       if ($dstFieldType == 'date') $value = DateTimeField::convertToUserFormat($value);
       // if ($dstFieldType == 'time') $value = Vtiger_Time_UIType::getDisplayValue($value);
       if ($dstFieldType == 'double') $value = decimalFormat($value);
       if ($dstFieldType == 'currency') $value = CurrencyField::convertToUserFormat($value, null, true);

       $convertedValues[] = array('name' => $dstFieldName,
                                  'type' => $dstFieldType,
                                  'value' => $value,
                                  'display' => $label
                            );
     }

     $this->emit($convertedValues);
  }

  private function emit($convertedValues) {

    $response = new Vtiger_Response();
    $response->setEmitType(Vtiger_Response::$EMIT_JSON);
    $response->setResult($convertedValues);
    $response->emit();
  }
}
