<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Settings_VebEmailConsent_Edit_View extends Settings_Vtiger_Index_View {

  public function process(Vtiger_Request $request) {

    $moduleName = $request->getModule();
    $qualifiedModuleName = 'Settings:VebEmailConsent';

    $recordModel = Settings_VebEmailConsent_Record_Model::getInstance();

    $emailLeadsTemplates = EmailTemplates_Record_Model::getAllForEmailTask('Leads');
    $emailContactsTemplates = EmailTemplates_Record_Model::getAllForEmailTask('Contacts');

    $systemUsers = get_user_array();
    $users = array();
    foreach($systemUsers as $userId => $userName) {

      if ($userName == '') continue;

      $emailAddress = getUserEmail($userId);
      $users[$userId] = array('username' => $userName, 'email' => $emailAddress);
    }

    $viewer = $this->getViewer($request);

    $viewer->assign('TEMPLATES_LEADS',$emailLeadsTemplates);
    $viewer->assign('TEMPLATES_CONTACTS',$emailContactsTemplates);
    $viewer->assign('RECORD_MODEL', $recordModel);
    $viewer->assign('MODULE', $moduleName);
    $viewer->assign('QUALIFIED_MODULE', $qualifiedModuleName);
    $viewer->assign('USERS', $users);

    $viewer->view('Edit.tpl', $qualifiedModuleName);
  }

  /**
   * Function to get the list of Script models to be included
   * @param Vtiger_Request $request
   * @return <Array> - List of Vtiger_JsScript_Model instances
   */
  function getHeaderScripts(Vtiger_Request $request) {
    $headerScriptInstances = parent::getHeaderScripts($request);
    $moduleName = $request->getModule();

    $jsFileNames = array(
      "modules.Settings.$moduleName.resources.Edit"
    );

    $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
    $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
    return $headerScriptInstances;
  }
    
    /**
     * Setting module related Information to $viewer (for Vtiger7)
     * @param type $request
     * @param type $moduleModel
     */
    public function setModuleInfo($request, $moduleModel){
        $record = $request->get('record');
    if ($record) {
      $viewer = $this->getViewer($request);
      $listViewModel = Settings_Vtiger_ListView_Model::getInstance($request->getModule(false));
      $linkParams = array('MODULE'=>$request->getModule(false), 'ACTION'=>$request->get('view'));

      if(!$this->listViewLinks){
        $this->listViewLinks = $listViewModel->getListViewLinks($linkParams);
      }
      $viewer->assign('LISTVIEW_LINKS', $this->listViewLinks);
    }
  }
}
