<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Settings_VebEmailConsent_Detail_View extends Settings_Vtiger_Index_View {
  
  public function process(Vtiger_Request $request) {
    
    $qualifiedModuleName = 'Settings:VebEmailConsent';
    
    $recordModel = Settings_VebEmailConsent_Record_Model::getInstance();

    $emailLeadsTemplates = EmailTemplates_Record_Model::getAllForEmailTask('Leads');
    $emailContactsTemplates = EmailTemplates_Record_Model::getAllForEmailTask('Contacts');

    $systemUsers = get_user_array();
    $users = array();
    foreach($systemUsers as $userId => $userName) {

      if ($userName == '') continue;

      $emailAddress = getUserEmail($userId);
      $users[$userId] = array('username' => $userName, 'email' => $emailAddress);
    }

    $viewer = $this->getViewer($request);

    $viewer->assign('TEMPLATES_LEADS',$emailLeadsTemplates);
    $viewer->assign('TEMPLATES_CONTACTS',$emailContactsTemplates);
    $viewer->assign('RECORD_MODEL', $recordModel);
    $viewer->assign('CURRENT_USER_MODEL', Users_Record_Model::getCurrentUserModel());
    $viewer->assign('QUALIFIED_MODULE', $qualifiedModuleName);
    $viewer->assign('USERS', $users);    

    $viewer->view('Detail.tpl',$qualifiedModuleName);
  }
}
