<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

include_once('includes/exceptions/AppException.php');
require_once 'include/events/include.inc';

/**
 * Roles Record Model Class
 */
class Settings_VebEmailConsent_Record_Model extends Settings_Vtiger_Record_Model {

  const tableName = 'vtiger_veb_emailconsent_settings';

  /**
   * Function to get the Id
   * @return <Number> Group Id
   */
  public function getId() {

    return $this->get('id');
  }

  /**
   * Function to set the Id
   * @param <Number> Group Id
   * @return <Settings_Groups_Reord_Model> instance
   */
  public function setId($id) {

    return $this->set('id', $id);
  }

  /**
   * Function to get the Group Name
   * @return <String>
   */
  public function getName() {

    return $this->get('id');
  }

  /**
   * Function to get the Edit View Url for the Group
   * @return <String>
   */
  public function getEditViewUrl() {

    return '?module=VebEmailConsent&parent=Settings&view=Edit';
  }

    /**
     * Function to get the Detail Url for the current group
     * @return <String>
     */
    public function getDetailViewUrl() {

        return '?module=VebEmailConsent&parent=Settings&view=Detail';
    }


  /**
   * Function to save the role
   */
  public function save() {

    $db = PearDatabase::getInstance();

    $id = $this->getId();

    $params = array();
    array_push($params, $this->get('leads_invite_tpl_id'),
                        $this->get('leads_remind_tpl_id'),
                        $this->get('leads_confirm_optout_tpl_id'),
                        $this->get('contacts_invite_tpl_id'),
                        $this->get('contacts_remind_tpl_id'),
                        $this->get('contacts_confirm_optout_tpl_id'),
                        $this->get('emailconsent_from_id'),
                        $this->get('emailconsent_to_id'),
                        $this->get('send_reminder_delta'),
                        $this->get('set_expired_delta'),
                        $this->get('company_privacy_link'),
                        $this->get('company_contact_link')
          );

    if(empty($id)) {

      $id = $db->getUniqueID(self::tableName);

      // To keep id in the beginning
      array_unshift($params, $id);

      $query = 'INSERT INTO ' . self::tableName . ' VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)';
    }
    else {

      $query = 'UPDATE ' . self::tableName . ' SET leads_invite_tpl_id = ?,
                                                   leads_remind_tpl_id= ?,
                                                   leads_confirm_optout_tpl_id = ?,
                                                   contacts_invite_tpl_id = ?,
                                                   contacts_remind_tpl_id = ?,
                                                   contacts_confirm_optout_tpl_id = ?,
                                                   emailconsent_from_id = ?,
                                                   emailconsent_to_id = ?,
                                                   send_reminder_delta = ?,
                                                   set_expired_delta = ?,
                                                   company_privacy_link  = ?,
                                                   company_contact_link  = ?
                                               WHERE id = ?';
      $params[] = $id;
    }

    $db->pquery($query,$params);

    return $id;
  }

  public static function getInstance() {

    $componentName = 'VebEmailConsent';
    $db = PearDatabase::getInstance();

    $query = 'SELECT * FROM ' . self::tableName;
    $params = array();
    $result = $db->pquery($query,$params);

    try {

      $modelClassName = Vtiger_Loader::getComponentClassName('Model', $componentName, 'Settings:Vtiger');
    }
    catch(Exception $e) {

      $modelClassName = new self;
    }

    $instance = new $modelClassName();
    $instance->configured = false;

    if($db->num_rows($result) > 0 ){

      $rowData = $db->query_result_rowdata($result,0);
      $instance->setData($rowData);
      $instance->configured = true;
    }

    return $instance;
  }
}
