<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

class Settings_VebEmailConsent_SaveAjax_Action extends Settings_Vtiger_Basic_Action {
  
  public function process(Vtiger_Request $request) {

    $vebEmailConsentSettingsModel = Settings_VebEmailConsent_Record_Model::getInstance();

    $vebEmailConsentSettingsModel->setData($request->getAll());
    $response = new Vtiger_Response();

    try {

      $id = $vebEmailConsentSettingsModel->save($request);
      $data = $vebEmailConsentSettingsModel->getData();

      $response->setResult($data);
    }
    catch(Exception $e) {

      $response->setError($e->getCode(), $e->getMessage());
    }

    $response->emit();
  }
  
  public function validateRequest(Vtiger_Request $request) {

    $request->validateWriteAccess();
  }
}
