<?php
/* +***********************************************************************************************************************************
 * The contents of this file are subject to the YetiForce Public License Version 1.1 (the "License"); you may not use this file except
 * in compliance with the License.
 * Software distributed under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is YetiForce.
 * The Initial Developer of the Original Code is YetiForce. Portions created by YetiForce are Copyright (C) www.yetiforce.com. 
 * All Rights Reserved.
 * *********************************************************************************************************************************** */




class Settings_VebCompanyData_Module_Model extends Settings_Vtiger_Module_Model
{

	public function getConfig()
	{
		$db = PearDatabase::getInstance();
		$result = $db->query("SELECT * FROM vtiger_bruteforce", true);
		for ($i = 0; $i < $db->num_rows($result); $i++) {
			$output[] = $db->query_result($result, $i, 'value');
		}
		return $output;
	}

	public function getCompanyDataSettings()
	{
		$db = PearDatabase::getInstance();
		$result = $db->query("SELECT * FROM veb_company_data_settings", true);
		$output = $db->query_result_rowdata($result, 0);

		return $output;
	}

	public static function updateConfig($username, $password,$dataprovide,$update_frequency)
	{
		$adb = PearDatabase::getInstance();

		$query = "UPDATE veb_company_data_settings SET username = ?, password = ?, dataprovide = ?, update_frequency = ? WHERE id =1";
		$params = array($username, $password, $dataprovide, $update_frequency);
		$result = $adb->pquery($query, $params);

		return $result;
	}

	
}
