<?php

/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */

/**
 * Email Template Model Class
 */
class Settings_Mosaico_Module_Model extends Settings_Vtiger_Module_Model {

    /**
     * Function retruns List of Email Templates
     * @return string
     */
    function getListViewUrl() {
        return 'module=Mosaico&parent=Settings&view=List';
    }

    /**
     * Function returns all the Email Template Models
     * @return <Array of Mosaico_Record_Model>
     */
    function getAll() {
        global $root_directory;
        $db = PearDatabase::getInstance();
        $result = $db->pquery('SELECT * FROM vtiger_mosaico inner join vtiger_mosaicocf on vtiger_mosaico.templateid = vtiger_mosaicocf.templateid inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_mosaico.templateid WHERE vtiger_crmentity.deleted = 0', array());

        $emailTemplateModels = array();
        for ($i = 0; $i < $db->num_rows($result); $i++) {
            $emailTemplateModel = Settings_Mosaico_Record_Model::getInstance();
            $emailTemplateModel->setData($db->query_result_rowdata($result, $i));
            $recordId = $emailTemplateModel->getId();
            $templatePath = $root_directory.'modules/Mosaico/storage/'.$recordId.'.html';
            if (is_file($templatePath)) {
                $body = file_get_contents($templatePath);
                $emailTemplateModel->set('body',$body);
                $emailTemplateModels[] = $emailTemplateModel;
            }
        }

        return $emailTemplateModels;
    }

}
