<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Settings_MailConverter_SelectMailConverters_View extends Settings_Vtiger_Index_View {

	function __construct() {
		parent::__construct();
		$this->exposeMethod('selectMailConverters');
		$this->exposeMethod('loginOffice365Account');
	}

	public function process(Vtiger_Request $request) {
		$mode = $request->get('mode');
		if (!empty($mode)) {
			$this->invokeExposedMethod($mode, $request);
			return;
		}
	}

	public function selectMailConverters(Vtiger_Request $request) {
		$qualifiedModuleName = $request->getModule(false);
		$viewer = $this->getViewer($request);
		$viewer->view('SelectMailConverters.tpl', $qualifiedModuleName);
	}

	public function loginOffice365Account(Vtiger_Request $request) {
		$qualifiedModuleName = $request->getModule(false);

		global $adb, $site_URL;
		$query = $adb->pquery("SELECT * FROM vtiger_mailscanner_license", array());
		$licenseRow = $adb->num_rows($query);

		$office365query = $adb->pquery("SELECT * FROM vtiger_mailscanner WHERE protocol = 'office365'", array());
		$office365rows = $adb->num_rows($office365query);
		if($office365rows){
			$scannerid = $adb->query_result($office365query, 0, 'scannerid');
		}

		$viewer = $this->getViewer($request);
		$viewer->assign('LICENSEROW', $licenseRow);
		$viewer->assign('site_URL', $site_URL);
		$viewer->assign('scannerid', $scannerid);
		if($licenseRow == 1){
			$viewer->view('LoginOffice365Account.tpl', $qualifiedModuleName);
		}else{
			$viewer->view('License.tpl', $qualifiedModuleName);
		}
	}

	function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
            "modules.Settings.$moduleName.resources.License",
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($jsScriptInstances,$headerScriptInstances);
        return $headerScriptInstances;
    }

}
