<?php
	
/************************************************************************************
 * The content of this file is subject to the Label Update ("License");
 * You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is CRMTiger.com
 * Portions created by CRMTiger.com. are Copyright(C) CRMTiger.com.
 * All Rights Reserved.
 *************************************************************************************/

require_once 'vtlib/Vtiger/Net/Client.php';

class Settings_MailConverter_License_View extends Settings_Vtiger_Index_View {
	
	const UNIQUEKEY = '3MbJuw0q';
	const SECRETKEY = 'dkH5jfRAMO';
	const SECRETIV = 'BPRYyNhxWu';
	const API_URL = "https://crmtiger.com/checklicense.php";
	const LICENSETABLE = "vtiger_mailscanner_license";
	
	function __construct() {
		parent::__construct();
        $this->exposeMethod('ActivateLicense');
        $this->exposeMethod('deactivateLicense');
        $this->exposeMethod('LicenseStatus');
	}
	
	function checkPermission(Vtiger_Request $request) {
		return true;
	}
	
	function process(Vtiger_Request $request) {
		$mode = $request->get('mode');
		if (!empty($mode)) {
			$this->invokeExposedMethod($mode, $request);
			return;
		}
	}
	
	public function ActivateLicense(Vtiger_Request $request) {
		global $site_URL, $adb;
		$moduleName = $request->get('module');
		$licensekey = $request->get("licensekey");
		$uniqueKey = self::UNIQUEKEY;
		
		$isvalid = "";
		if ($licensekey != "") {
			$isvalid = $this->validateLicense('activate', $licensekey, $site_URL);
		}

		if ($isvalid == "validated") {
			$auth_key = md5($site_URL.$licensekey.$uniqueKey);
			$adb->pquery("DELETE FROM ".self::LICENSETABLE , array());
			$adb->pquery("INSERT INTO ".self::LICENSETABLE." (licensekey,authkey) values(?,?)", array($licensekey, $auth_key));
			
			echo 1;
		} else {
			if (trim($isvalid) != "" && trim($isvalid) != "invalidated"){
				echo 0;
			} else {
				echo 0;
			}
		}

		$response = new Vtiger_Response();
		try {
			$response->setResult($result);
		} catch(Exception $e) {
			$response->setError($e->getCode() , $e->getMessage());
		}
		//$response->emit();
	}
	
	public function deactivateLicense(Vtiger_Request $request) {
		global $site_URL, $adb;
		$message = "";
		$currentUser = Users_Record_Model::getCurrentUserModel();
		if($currentUser->isAdminUser()) {
			$moduleName = $request->get('module');
			$result = $adb->pquery("SELECT * FROM ".self::LICENSETABLE, array());
			$no_of_rows = $adb->num_rows($result);
			if($no_of_rows > 0){
				$licensekey = $adb->query_result($result, 0,'licensekey');
				
				$isvalid = "";
				if ($licensekey != "") {
					$isvalid = $this->validateLicense('deactivate', $licensekey, $site_URL);
				}
				
				if ($isvalid == "validated") {
					$adb->pquery("DELETE FROM ".self::LICENSETABLE, array());
					
					echo 1;
				} else {
					if (trim($isvalid) != "" && trim($isvalid) != "invalidated"){
						echo 0;
					} else {
						echo 0;
					}
				}
			} else {
				$result = array(
					"success" => false,
					"message" => vtranslate("LBL_NO_LICENSE_EXISTS", "Vtiger")
				);
			}
		} else {
			$result = array(
				"success" => false,
				"message" => vtranslate("LBL_PERMISSION_DENIED", "Vtiger")
			);
		}

		$response = new Vtiger_Response();
		try {
			$response->setResult($result);
		} catch(Exception $e) {
			$response->setError($e->getCode() , $e->getMessage());
		}
		//$response->emit();
	}
	
    public static function LicenseStatus() {
    	global $site_URL, $adb;
		$uniqueKey = self::UNIQUEKEY;

        $result = $adb->pquery("SELECT * FROM ".self::LICENSETABLE, array());
		$no_of_rows = $adb->num_rows($result);
    	if($no_of_rows > 0){
			$licensekey = $adb->query_result($result, 0,'licensekey');
			$authkey = $adb->query_result($result, 0,'authkey');
			$auth_key = md5($site_URL.$licensekey.$uniqueKey);
			if($auth_key == $authkey){
				return 1;
			}else{
				return 0;
			}
		}else{
			return 0;
		}
    }
	
	private function validateLicense($type, $licensekey, $site_URL) {
		global $site_URL, $adb;
		$API_URL = self::API_URL;
		$time = time();
		$string = $type.'||'.$licensekey.'||'.$site_URL.'||'.$time;
		$encrypted_key = $this->encrypt_decrypt($string,'e');
		$postData = array('ct' => $encrypted_key);
		
		$httpClient = new Vtiger_Net_Client($API_URL);
        $response = $httpClient->doPost(array($postData));
        $response = trim($response);
		return $response;
	}
	
	public function encrypt_decrypt( $string, $action = 'e' ) {
		$secret_key = self::SECRETKEY;
        $secret_iv = self::SECRETIV;

        $output = false;
        $encrypt_method = "AES-256-CBC";
        $key = hash( 'sha256', $secret_key );
        $iv = substr( hash( 'sha256', $secret_iv ), 0, 16 );

        if($action == 'e') {
            $output = base64_encode( openssl_encrypt( $string, $encrypt_method, $key, 0, $iv ) );
        } else if($action == 'd'){
            $output = openssl_decrypt( base64_decode( $string ), $encrypt_method, $key, 0, $iv );
        }
        return $output;
    }
}
