<?php
/*********************************************************************************
 * The content of this file is subject to the ListView Colors 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class Settings_ListViewColors_List_View extends Settings_Vtiger_List_View {

    var $isInstalled = true;
    var $version_type = "";

    public function preProcess(Vtiger_Request $request, $display=true) {
        $viewer = $this->getViewer($request);
        $viewer->assign('SUPPORTED_MODULE_MODELS', Settings_ListViewColors_Module_Model::getSupportedModules());

        $adb = PearDatabase::getInstance();
        $vcv = vglobal('vtiger_current_version');

        $result = $adb->query("SELECT version FROM its4you_listviewcolors_version WHERE version='" . $vcv . "'");

        if ($result && $adb->num_rows($result) > 0) {
            $viewer->assign('IS_LVS_INSTALLED', "yes");
            $this->version_type = $adb->query_result($result,0,"version"); 
            
            $ListViewColorsModel = new ListViewColors_Module_Model();
            $this->version_type = $ListViewColorsModel->GetVersionType();
            $viewer->assign("VERSION_TYPE", $this->version_type);
        } else {
            $this->isInstalled = false;
        }
        parent::preProcess($request, true);
    }
            
    public function process(Vtiger_Request $request) {
        
        $adb = PearDatabase::getInstance();
        $vcv = vglobal('vtiger_current_version');

        $viewer = $this->getViewer($request);
    
        if ($this->isInstalled) {
            parent::process($request);

            $viewer->assign("VERSION_TYPE", $this->version_type);

        } else {

            $step = $current_step = 1;
            $total_steps = "2";
  
            $viewer->assign("STEP", $step);
            $viewer->assign("CURRENT_STEP", $current_step);
            $viewer->assign("TOTAL_STEPS", $total_steps);
            
            $viewer->view('Install.tpl', $request->getModule(false));
        }
    }
    
    function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
            'modules.Vtiger.resources.List',
            'modules.Settings.Vtiger.resources.List',
            'modules.Settings.ListViewColors.resources.License',
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }
}