<?php

/*********************************************************************************
 * The content of this file is subject to the ListView Colors 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class Settings_ListViewColors_Edit_View extends Settings_Vtiger_Index_View {

    public function process(Vtiger_Request $request) {
        $mode = $request->getMode();
        if ($mode) {
                $this->$mode($request);
        } else {
                $this->step1($request);
        }
    }

    public function preProcess(Vtiger_Request $request) {

        parent::preProcess($request);
        $viewer = $this->getViewer($request);

        $recordId = $request->get('record');
        $viewer->assign('RECORDID', $recordId);
        if($recordId) {
            $listViewColorsModel = Settings_ListViewColors_Record_Model::getInstance($recordId);
            $viewer->assign('LISTVIEWCOLORS_MODEL', $listViewColorsModel);
        }
        $viewer->assign('RECORD_MODE', $request->getMode());
        $viewer->view('EditHeader.tpl', $request->getModule(false));
    }

    public function step1(Vtiger_Request $request) {

        $currentUser = Users_Record_Model::getCurrentUserModel();
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $qualifiedModuleName = $request->getModule(false);

        $recordId = $request->get('record');
        if ($recordId) {
            $listViewColorsModel = Settings_ListViewColors_Record_Model::getInstance($recordId);
            $viewer->assign('RECORDID', $recordId);
            $viewer->assign('MODULE_MODEL', $listViewColorsModel->getModule());
            $viewer->assign('MODE', 'edit');
        } else {
            $listViewColorsModel = Settings_ListViewColors_Record_Model::getCleanInstance($moduleName);
            $selectedModule = $request->get('source_module');
            if(!empty($selectedModule)) {
                $viewer->assign('SELECTED_MODULE', $selectedModule);
            }
        }

        $viewer->assign('LISTVIEWCOLORS_MODEL', $listViewColorsModel);
        $viewer->assign('ALL_MODULES', Settings_ListViewColors_Module_Model::getSupportedModules());

        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('QUALIFIED_MODULE', $qualifiedModuleName);
        $viewer->assign('CURRENT_USER', $currentUser);
        $admin = Users::getActiveAdminUser();
        $viewer->assign('ACTIVE_ADMIN', $admin);
        $viewer->view('Step1.tpl', $qualifiedModuleName);
    }

    public function step2(Vtiger_Request $request) {

        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $qualifiedModuleName = $request->getModule(false);

        $recordId = $request->get('record');

        if ($recordId) {
                $listViewColorsModel = Settings_ListViewColors_Record_Model::getInstance($recordId);
                $selectedModule = $listViewColorsModel->getModule();
                $selectedModuleName = $selectedModule->getName();
        } else {
                $selectedModuleName = $request->get('module_name');
                $selectedModule = Vtiger_Module_Model::getInstance($selectedModuleName);
                $listViewColorsModel = Settings_ListViewColors_Record_Model::getCleanInstance($selectedModuleName);
        }

        $requestData = $request->getAll();
        foreach($requestData as $name=>$value) {
                $listViewColorsModel->set($name,$value);
        }

        $recordStructureInstance = Settings_ListViewColors_RecordStructure_Model::getInstanceForListViewColorsModule($listViewColorsModel, Settings_ListViewColors_RecordStructure_Model::RECORD_STRUCTURE_MODE_FILTER);

        $viewer->assign('RECORD_STRUCTURE_MODEL', $recordStructureInstance);

        $recordStructure = $recordStructureInstance->getStructure();
        if(in_array($selectedModuleName,  getInventoryModules())){
            $itemsBlock = "LBL_ITEM_DETAILS";
            unset($recordStructure[$itemsBlock]);
        }
        $viewer->assign('RECORD_STRUCTURE', $recordStructure);

                
        $viewer->assign('LISTVIEWCOLORS_MODEL',$listViewColorsModel);

        $viewer->assign('MODULE_MODEL', $selectedModule);
        $viewer->assign('SELECTED_MODULE_NAME', $selectedModuleName);

        $dateFilters = Vtiger_Field_Model::getDateFilterTypes();
        foreach($dateFilters as $comparatorKey => $comparatorInfo) {
            $comparatorInfo['startdate'] = DateTimeField::convertToUserFormat($comparatorInfo['startdate']);
            $comparatorInfo['enddate'] = DateTimeField::convertToUserFormat($comparatorInfo['enddate']);
            $comparatorInfo['label'] = vtranslate($comparatorInfo['label'], $qualifiedModuleName);
            $dateFilters[$comparatorKey] = $comparatorInfo;
        }
        $viewer->assign('DATE_FILTERS', $dateFilters);
        $viewer->assign('ADVANCED_FILTER_OPTIONS', Settings_ListViewColors_Field_Model::getAdvancedFilterOptions());
        $viewer->assign('ADVANCED_FILTER_OPTIONS_BY_TYPE', Settings_ListViewColors_Field_Model::getAdvancedFilterOpsByFieldType());
        $viewer->assign('FIELD_EXPRESSIONS', Settings_ListViewColors_Module_Model::getExpressions());
        $viewer->assign('META_VARIABLES', Settings_ListViewColors_Module_Model::getMetaVariables());
        $viewer->assign('ADVANCE_CRITERIA', $listViewColorsModel->transformToAdvancedFilterCondition());
        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('QUALIFIED_MODULE', $qualifiedModuleName);
        $viewer->view('Step2.tpl', $qualifiedModuleName);
    }

    function Step3(Vtiger_Request $request) {
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $qualifiedModuleName = $request->getModule(false);

        $recordId = $request->get('record');

        if ($recordId) {
                $listViewColorsModel = Settings_ListViewColors_Record_Model::getInstance($recordId);
                $selectedModule = $listViewColorsModel->getModule();
                $selectedModuleName = $selectedModule->getName();
        } else {
                $selectedModuleName = $request->get('module_name');
                $selectedModule = Vtiger_Module_Model::getInstance($selectedModuleName);
                $listViewColorsModel = Settings_ListViewColors_Record_Model::getCleanInstance($selectedModuleName);
        }

        $moduleModel = $listViewColorsModel->getModule();

        $viewer->assign('SOURCE_MODULE',$selectedModuleName);
        $viewer->assign('RECORD',$recordId);
        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('LISTVIEWCOLORS_MODEL',$listViewColorsModel);
        $viewer->assign('QUALIFIED_MODULE',$qualifiedModuleName);
        $viewer->view('Step3.tpl', $qualifiedModuleName);
    }

    public function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
                "modules.ListViewColors.resources.colorpicker.js.colorpicker",
                "modules.Settings.Vtiger.resources.Edit",
                "modules.Settings.$moduleName.resources.Edit",
                "modules.Settings.$moduleName.resources.Edit1",
                "modules.Settings.$moduleName.resources.Edit2",
                "modules.Settings.$moduleName.resources.Edit3",
                "modules.Settings.$moduleName.resources.AdvanceFilter",
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }

    public function getHeaderCss(Vtiger_Request $request) {
        $headerCssInstances = parent::getHeaderCss($request);

        $cssFileNames = array(
            '~/modules/ListViewColors/resources/colorpicker/css/colorpicker.css'
        );
        $cssInstances = $this->checkAndConvertCssStyles($cssFileNames);
        $headerCssInstances = array_merge($headerCssInstances, $cssInstances);
        return $headerCssInstances;
    }
}