<?php

/*********************************************************************************
 * The content of this file is subject to the ListView Colors 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

require_once 'modules/com_vtiger_workflow/include.inc';
require_once 'modules/com_vtiger_workflow/expression_engine/VTExpressionsManager.inc';

class Settings_ListViewColors_Record_Model extends Settings_Vtiger_Record_Model {

    var $ConvertDate = array('is', 'is not', 'between', 'before', 'after', 'in less than', 'in more than');
    
    public function getId() {
        return $this->get('listviewcolorid');
    }

    public function getName() {
        return $this->get('description');
    }

    public function get($key) {
        return parent::get($key);
    }

    public function getEditViewUrl() {
        return 'index.php?module=ListViewColors&parent=Settings&view=Edit&record='.$this->getId();
    }
   
    public function getModule() {
        return $this->module;
    }

    public function setModule($moduleName) {
        $this->module = Vtiger_Module_Model::getInstance($moduleName);
        return $this;
    }

    public function isDefault() {
        return true;
    }

    public function save() {
        $adb = PearDatabase::getInstance();

        $listviewcolorid = $this->get('listviewcolorid');
        $description = $this->get('description');
        $moduleName = $this->get('module_name');
        $lvc_conditions = Zend_Json::encode($this->get('conditions'));

        $color = $this->get('color');

        if(isset($listviewcolorid) && $listviewcolorid != "" && $listviewcolorid != "0"){

            $sql = "UPDATE its4you_listviewcolors SET description = ?, module_name = ?, lvc_conditions =? WHERE listviewcolorid = ?";
            $params = array($description, $moduleName, $lvc_conditions, $listviewcolorid);

        } else {

            $listviewcolorid = $adb->getUniqueID("its4you_listviewcolors");

            $sql = "INSERT INTO its4you_listviewcolors (listviewcolorid, description, module_name, lvc_conditions, color) VALUES (?, ?, ?, ?, ?)";
            $params = array($listviewcolorid, $description, $moduleName, $lvc_conditions, $color);
        }
        $adb->pquery($sql, $params);

        $this->set('listviewcolorid', $listviewcolorid);
    }

    public function updateColor() {
        $adb = PearDatabase::getInstance();

        $listviewcolorid = $this->get('listviewcolorid');
        $color = $this->get('color');
     
        $sql = "UPDATE its4you_listviewcolors SET color = ? WHERE listviewcolorid = ?";
        $adb->pquery($sql, array($color, $listviewcolorid));
    }
    
    public function delete() {
        $adb = PearDatabase::getInstance();

        $listviewcolorid = $this->getId();
        $sql = "UPDATE its4you_listviewcolors SET deleted = '1' WHERE listviewcolorid = ?";
        $adb->pquery($sql, array($listviewcolorid));
    }

    public function getEntityMethods() {
            $db = PearDatabase::getInstance();
            $emm = new VTEntityMethodManager($db);
            $methodNames = $emm->methodsForModule($this->get('module_name'));
            return $methodNames;
    }

    public function getRecordLinks() {

            $links = array();

            $recordLinks = array(
                    array(
                            'linktype' => 'LISTVIEWRECORD',
                            'linklabel' => 'LBL_EDIT_RECORD',
                            'linkurl' => $this->getEditViewUrl(),
                            'linkicon' => 'icon-pencil'
                    ),
                    array(
                            'linktype' => 'LISTVIEWRECORD',
                            'linklabel' => 'LBL_DELETE_RECORD',
                            'linkurl' => 'javascript:Vtiger_List_Js.deleteRecord('.$this->getId().');',
                            'linkicon' => 'icon-trash'
                    )
            );
            foreach($recordLinks as $recordLink) {
                    $links[] = Vtiger_Link_Model::getInstanceFromValues($recordLink);
            }

            return $links;
    }

    public static function getInstance($listviewcolorid) {

        $adb = PearDatabase::getInstance();

        $sql = "SELECT * FROM its4you_listviewcolors WHERE listviewcolorid = ?";
        $result = $adb->pquery($sql, array($listviewcolorid));

        if($adb->num_rows($result)){
            $data = $adb->raw_query_result_rowdata($result, 0);
            return self::getInstanceObject($data);
        }else{
            return null;
        }
    }

    public static function getCleanInstance($moduleName) {
        $adb = PearDatabase::getInstance();
        $data = array("module_name" => $moduleName,"color" => "#ffffff");
        return self::getInstanceObject($data);
    }

    public static function getInstanceObject($data) {
        $ListViewColorsModel = new self();

        $ListViewColorsModel->set('color', $data["color"]);
        $ListViewColorsModel->set('description', $data["description"]);
        $ListViewColorsModel->set('conditions', Zend_Json::decode($data["lvc_conditions"]));
        $ListViewColorsModel->set('module_name', $data["module_name"]);
        $ListViewColorsModel->set('listviewcolorid', $data["listviewcolorid"]);
        $ListViewColorsModel->setModule($data["module_name"]);
        return $ListViewColorsModel;
    }

    function transformToAdvancedFilterCondition() {
        $conditions = $this->get('conditions');
        
        $transformedConditions = array();
        
        if(!empty($conditions)) {
            foreach($conditions as $index => $info) {

                list($columntable, $columnname, $fieldname, $label, $columntype) = explode(":",$info['fieldname']);

                if ($columntype == "D" && $info['valuetype'] == "rawtext" && in_array($info['operation'],$this->ConvertDate)) {

                    if ($info['operation'] == "between") {
                        $values = $info['value'];
                        $values = array_map('Vtiger_Datetime_UIType::getDisplayDateValue',$values);
                        $info['value'] = implode(",",$values);
                    } else {
                        $info['value'] = Vtiger_Datetime_UIType::getDisplayDateValue($info['value']);
                    }
                }


                if(!($info['groupid'])) {
                        $firstGroup[] = array('columnname' => $info['fieldname'], 'comparator' => $info['operation'], 'value' => $info['value'],
                                'column_condition' => $info['joincondition'], 'valuetype' => $info['valuetype'], 'groupid' => $info['groupid']);
                } else {
                        $secondGroup[] = array('columnname' => $info['fieldname'], 'comparator' => $info['operation'], 'value' => $info['value'],
                                'column_condition' => $info['joincondition'], 'valuetype' => $info['valuetype'], 'groupid' => $info['groupid']);
                }
            }
        }
        
        $transformedConditions[1] = array('columns'=>$firstGroup);
        $transformedConditions[2] = array('columns'=>$secondGroup);

        return $transformedConditions;
    }

    function getFieldFilterValueType($c_fieldname) {
        $conditions = $this->get('conditions');
        if(!empty($conditions) && is_array($conditions)) {
            foreach($conditions as $filter) {

                list($columntable, $columnname, $fieldname, $label, $columntype) = explode(":",$filter['fieldname']);
                if($c_fieldname == $fieldname) {
                        return $filter['valuetype'];
                }
            }
        }

        return false;
    }

    function transformAdvanceFilterToListViewColorFilter() {
        $conditions = $this->get('conditions');
        $wfCondition = array();

        if(!empty($conditions)) {
            foreach($conditions as $index => $condition) {
                $columns = $condition['columns'];
                if($index == '1' && empty($columns)) {
                        $wfCondition[] = array('fieldname'=>'', 'operation'=>'', 'value'=>'', 'valuetype'=>'', 
                                'joincondition'=>'', 'groupid'=>'0');
                }
                if(!empty($columns) && is_array($columns)) {
                    foreach($columns as $column) {

                        list($columntable, $columnname, $fieldname, $label, $columntype) = explode(":",$column['columnname']);

                        if ($columntype == "D" && $column['valuetype'] == "rawtext" && in_array($column['comparator'],$this->ConvertDate)) {

                            if ($column['comparator'] == "between") {
                                $values = explode(',', $column['value']);
                                $column['value'] = array_map('getValidDBInsertDateValue',$values);
                            } else {
                                $column['value'] = getValidDBInsertDateValue($column['value']);
                            }
                        }    

                        $wfCondition[] = array('fieldname'=>$column['columnname'], 'operation'=>$column['comparator'],
                                    'value'=>$column['value'], 'valuetype'=>$column['valuetype'], 'joincondition'=>$column['column_condition'],
                                    'groupjoin'=>$condition['condition'], 'groupid'=>$column['groupid']);
                    }
                }
            }
        }
        $this->set('conditions', $wfCondition);
    }

    public function getDependentModules() {
        $db = PearDatabase::getInstance();
        $moduleName = $this->getModule()->getName();

        $result = $db->pquery("SELECT fieldname, tabid, typeofdata, vtiger_ws_referencetype.type as reference_module FROM vtiger_field
                                                        INNER JOIN vtiger_ws_fieldtype ON vtiger_field.uitype = vtiger_ws_fieldtype.uitype
                                                        INNER JOIN vtiger_ws_referencetype ON vtiger_ws_fieldtype.fieldtypeid = vtiger_ws_referencetype.fieldtypeid
                                                UNION
                                                SELECT fieldname, tabid, typeofdata, relmodule as reference_module FROM vtiger_field
                                                        INNER JOIN vtiger_fieldmodulerel ON vtiger_field.fieldid = vtiger_fieldmodulerel.fieldid", array());

        $noOfFields = $db->num_rows($result);

        $dependentFields = array();
        $filterModules = array('Invoice', 'Quotes', 'SalesOrder', 'PurchaseOrder', 'Emails', 'Calendar', 'Events', 'Accounts');
        $skipFieldsList = array();
        for ($i = 0; $i < $noOfFields; ++$i) {
                $tabId = $db->query_result($result, $i, 'tabid');
                $fieldName = $db->query_result($result, $i, 'fieldname');
                $typeOfData = $db->query_result($result, $i, 'typeofdata');
                $referenceModule = $db->query_result($result, $i, 'reference_module');
                $tabModuleName = getTabModuleName($tabId);
                if (in_array($tabModuleName, $filterModules))
                        continue;
                if ($referenceModule == $moduleName && $tabModuleName != $moduleName) {
                        if(!vtlib_isModuleActive($tabModuleName))continue;
                        $dependentFields[$tabModuleName] = array('fieldname' => $fieldName, 'modulelabel' => getTranslatedString($tabModuleName, $tabModuleName));            
                } else {
                        $dataTypeInfo = explode('~', $typeOfData);
                        if ($dataTypeInfo[1] == 'M') { // If the current reference field is mandatory
                                $skipFieldsList[$tabModuleName] = array('fieldname' => $fieldName);
                        }
                }
        }
        foreach ($skipFieldsList as $tabModuleName => $fieldInfo) {
                $dependentFieldInfo = $dependentFields[$tabModuleName];
                if ($dependentFieldInfo['fieldname'] != $fieldInfo['fieldname']) {
                        unset($dependentFields[$tabModuleName]);
                }
        }

        return $dependentFields;
    }

    public function getReferenceFieldName($relatedModule) {
        if ($relatedModule) {
            $db = PearDatabase::getInstance();

            $relatedModuleModel = Vtiger_Module_Model::getInstance($relatedModule);
            $referenceFieldsList = $relatedModuleModel->getFieldsByType('reference');

            foreach ($referenceFieldsList as $fieldName => $fieldModel) {
                if (in_array($this->getModule()->getName(), $fieldModel->getReferenceList())) {
                        return $fieldName;
                }
            }
        }
        return false;
    }
}