<?php

/*********************************************************************************
 * The content of this file is subject to the ListView Colors 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class Settings_ListViewColors_ListView_Model extends Settings_Vtiger_ListView_Model {

    public function getListViewEntries($pagingModel) {
        $adb = PearDatabase::getInstance();
        $module = $this->getModule();
        $moduleName = $module->getName();
        $parentModuleName = $module->getParentName();
        $qualifiedModuleName = $moduleName;
        if(!empty($parentModuleName)) {
            $qualifiedModuleName = $parentModuleName.':'.$qualifiedModuleName;
        }
        $recordModelClass = Vtiger_Loader::getComponentClassName('Model', 'Record', $qualifiedModuleName);

        $listFields = $module->listFields;
        $listQuery = "SELECT ";
        foreach ($listFields as $fieldName => $fieldLabel) {
            $listQuery .= "$fieldName, ";
        }
        $listQuery .= $module->baseIndex . " FROM ". $module->baseTable." WHERE";

        $params = array();
        $sourceModule = $this->get('sourceModule');
        if(!empty($sourceModule)) {
            $listQuery .= ' module_name = ? AND ';
            $params[] = $sourceModule;
        }
        $listQuery .= " deleted = '0' ";

        $startIndex = $pagingModel->getStartIndex();
        $pageLimit = $pagingModel->getPageLimit();

        $orderBy = $this->getForSql('orderby');
        if (!empty($orderBy) && $orderBy === 'smownerid') { 
            $fieldModel = Vtiger_Field_Model::getInstance('assigned_user_id', $moduleModel); 
            if ($fieldModel->getFieldDataType() == 'owner') { 
                    $orderBy = 'COALESCE(CONCAT(vtiger_users.first_name,vtiger_users.last_name),vtiger_groups.groupname)'; 
            } 
        }

        if(!empty($orderBy)) {
            $listQuery .= ' ORDER BY '. $orderBy . ' ' .$this->getForSql('sortorder');
        }
        $nextListQuery = $listQuery.' LIMIT '.($startIndex+$pageLimit).',1';
        $listQuery .= " LIMIT $startIndex,".($pageLimit+1);

        $listResult = $adb->pquery($listQuery, $params);
        $noOfRecords = $adb->num_rows($listResult);

        $listViewRecordModels = array();
        for($i=0; $i<$noOfRecords; ++$i) {
            $row = $adb->query_result_rowdata($listResult, $i);
            $record = new $recordModelClass();
            $module_name = $row["module_name"];
            
            if($module_name == 'Calendar'){
                $module_name = vtranslate('LBL_TASK', $module_name);
            }else{
                $module_name = vtranslate($module_name, $module_name);
            }

            $row['module_name'] = $module_name;

            $row['color'] = $row['color'];
            $record->setData($row);
            $listViewRecordModels[$record->getId()] = $record;
        }
        $pagingModel->calculatePageRange($listViewRecordModels);

        if($adb->num_rows($listResult) > $pageLimit){
            array_pop($listViewRecordModels);
            $pagingModel->set('nextPageExists', true);
        }else{
            $pagingModel->set('nextPageExists', false);
        }

        $nextPageResult = $adb->pquery($nextListQuery, $params);
        $nextPageNumRows = $adb->num_rows($nextPageResult);
        if($nextPageNumRows <= 0) {
            $pagingModel->set('nextPageExists', false);
        }
        return $listViewRecordModels;
    }

    public function getListViewCount() {
        $adb = PearDatabase::getInstance();

        $module = $this->getModule();
        $listQuery = 'SELECT count(*) AS count FROM ' . $module->baseTable;

        $sourceModule = $this->get('sourceModule');
        if($sourceModule) {
                $listQuery .= " WHERE module_name = '$sourceModule'";
        }

        $listResult = $adb->pquery($listQuery, array());
        return $adb->query_result($listResult, 0, 'count');
    }
}